/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.CrailBuffer;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class BufferCheckpoint {
    private static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<Long, CrailBuffer> checkpoint = new ConcurrentHashMap();

    public void checkIn(CrailBuffer buffer) throws Exception {
        long address = buffer.address();
        CrailBuffer oldBuf = this.checkpoint.putIfAbsent(address, buffer);
        if (oldBuf != null) {
            StackTraceElement[] stack;
            LOG.info("ERROR Buffer already in use!");
            for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
                LOG.info(element.toString());
            }
            throw new Exception("ERROR Buffer already in use!");
        }
    }

    public void checkOut(CrailBuffer buffer) {
        long address = buffer.address();
        this.checkpoint.remove(address);
    }
}

