/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageClient;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class EndpointCache
implements CrailStatistics.StatisticsProvider {
    private static final Logger LOG = CrailUtils.getLogger();
    private boolean isOpen;
    private ConcurrentHashMap<Integer, StorageEndpointCache> storageCaches = new ConcurrentHashMap();

    public EndpointCache(int fsId, LinkedList<StorageClient> storageClients) {
        int storageType = 0;
        for (StorageClient storageClient : storageClients) {
            StorageEndpointCache cache = new StorageEndpointCache(fsId, storageClient, storageType);
            this.storageCaches.put(storageType++, cache);
        }
        this.isOpen = true;
    }

    @Override
    public String providerName() {
        return "cache/endpoint";
    }

    @Override
    public String printStatistics() {
        return "size " + this.size();
    }

    @Override
    public void mergeStatistics(CrailStatistics.StatisticsProvider provider) {
    }

    @Override
    public void resetStatistics() {
    }

    public StorageEndpoint getDataEndpoint(DataNodeInfo dataNodeInfo) throws IOException, InterruptedException {
        StorageEndpointCache cache = this.storageCaches.get(dataNodeInfo.getStorageType());
        StorageEndpoint endpoint = cache.getDataEndpoint(dataNodeInfo);
        return endpoint;
    }

    public int size() {
        int size = 0;
        for (StorageEndpointCache cache : this.storageCaches.values()) {
            size += cache.size();
        }
        return size;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        for (StorageEndpointCache cache : this.storageCaches.values()) {
            cache.close();
        }
    }

    public static class StorageEndpointCache {
        private StorageClient storageClient;
        private ConcurrentHashMap<Long, Object> locktable;
        private ConcurrentHashMap<Long, StorageEndpoint> cache;
        private int fsId;
        private boolean isOpen;
        private int storageType;

        public StorageEndpointCache(int fsId, StorageClient storageClient, int storageType) {
            this.fsId = fsId;
            this.storageClient = storageClient;
            this.cache = new ConcurrentHashMap();
            this.locktable = new ConcurrentHashMap();
            this.isOpen = true;
            this.storageType = storageType;
        }

        public void close() throws IOException {
            if (!this.isOpen) {
                return;
            }
            try {
                this.storageClient.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StorageEndpoint getDataEndpoint(DataNodeInfo dataNodeInfo) throws IOException, InterruptedException {
            StorageEndpoint endpoint = this.cache.get(dataNodeInfo.key());
            if (endpoint == null) {
                Object lock;
                Object object = lock = this.getLock(dataNodeInfo.key());
                synchronized (object) {
                    endpoint = this.cache.get(dataNodeInfo.key());
                    if (endpoint == null) {
                        endpoint = this.storageClient.createEndpoint(dataNodeInfo);
                        this.cache.put(dataNodeInfo.key(), endpoint);
                        if (CrailConstants.DEBUG) {
                            LOG.info("EndpointCache miss " + CrailUtils.datanodeInfo2SocketAddr(dataNodeInfo) + ", fsId " + this.fsId + ", cache size " + this.cache.size());
                        }
                    }
                }
            } else if (CrailConstants.DEBUG) {
                LOG.info("EndpointCache hit " + CrailUtils.datanodeInfo2SocketAddr(dataNodeInfo) + ", fsId " + this.fsId);
            }
            return endpoint;
        }

        public int size() {
            return this.cache.size();
        }

        public int getStorageType() {
            return this.storageType;
        }

        private Object getLock(long key) {
            Object lock = this.locktable.get(key);
            if (lock == null) {
                lock = new Object();
                Object oldLock = this.locktable.putIfAbsent(key, lock);
                if (oldLock != null) {
                    lock = oldLock;
                }
            }
            return lock;
        }
    }
}

