/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;

public class NextBlockCache {
    private ConcurrentHashMap<Long, FileNextBlockCache> nextBlockCache = new ConcurrentHashMap();

    public FileNextBlockCache getFileBlockCache(long fd) {
        FileNextBlockCache fileBlockCache = this.nextBlockCache.get(fd);
        if (fileBlockCache == null) {
            fileBlockCache = new FileNextBlockCache(fd);
            FileNextBlockCache oldFileBlockCache = this.nextBlockCache.putIfAbsent(fd, fileBlockCache);
            if (oldFileBlockCache != null) {
                fileBlockCache = oldFileBlockCache;
            }
        }
        return fileBlockCache;
    }

    public void remove(long fd) {
        this.nextBlockCache.remove(fd);
    }

    public void purge() {
        this.nextBlockCache.clear();
    }

    public static class FileNextBlockCache {
        private long fd;
        private ConcurrentHashMap<Long, RpcFuture<RpcGetBlock>> fileBlockCache;

        public FileNextBlockCache(long fd) {
            this.fd = fd;
            this.fileBlockCache = new ConcurrentHashMap();
        }

        public void put(long blockstart, RpcFuture<RpcGetBlock> block) {
            this.fileBlockCache.putIfAbsent(blockstart, block);
        }

        public RpcFuture<RpcGetBlock> get(long blockstart) {
            return this.fileBlockCache.get(blockstart);
        }

        public boolean containsKey(long blockstart) {
            return this.fileBlockCache.containsKey(blockstart);
        }

        public long getFd() {
            return this.fd;
        }
    }
}

