/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.darpc;

import com.ibm.darpc.DaRPCClientEndpoint;
import com.ibm.darpc.DaRPCFuture;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCStream;
import java.io.IOException;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeFuture;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeRequest;
import org.apache.crail.namenode.rpc.darpc.DaRPCNameNodeResponse;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcCreateFile;
import org.apache.crail.rpc.RpcDeleteFile;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcGetFile;
import org.apache.crail.rpc.RpcGetLocation;
import org.apache.crail.rpc.RpcPing;
import org.apache.crail.rpc.RpcRenameFile;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.rpc.RpcResponseMessage;
import org.apache.crail.rpc.RpcVoid;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DaRPCNameNodeConnection
implements RpcConnection {
    private static final Logger LOG = CrailUtils.getLogger();
    private DaRPCClientEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse> rpcEndpoint;
    private DaRPCStream<DaRPCNameNodeRequest, DaRPCNameNodeResponse> stream;

    public DaRPCNameNodeConnection(DaRPCClientEndpoint<DaRPCNameNodeRequest, DaRPCNameNodeResponse> endpoint) throws IOException {
        this.rpcEndpoint = endpoint;
        this.stream = endpoint.createStream();
    }

    public RpcFuture<RpcCreateFile> createFile(FileName filename, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: createFile, fileType " + type + ", storageClass " + storageClass + ", locationClass " + locationClass);
        }
        RpcRequestMessage.CreateFileReq createFileReq = new RpcRequestMessage.CreateFileReq(filename, type, storageClass, locationClass, enumerable);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(createFileReq);
        request.setCommand((short)1);
        RpcResponseMessage.CreateFileRes fileRes = new RpcResponseMessage.CreateFileRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(fileRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.CreateFileRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.CreateFileRes>(future, fileRes);
        return nameNodeFuture;
    }

    public RpcFuture<RpcGetFile> getFile(FileName filename, boolean writeable) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: getFile, writeable " + writeable);
        }
        RpcRequestMessage.GetFileReq getFileReq = new RpcRequestMessage.GetFileReq(filename, writeable);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(getFileReq);
        request.setCommand((short)2);
        RpcResponseMessage.GetFileRes fileRes = new RpcResponseMessage.GetFileRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(fileRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.GetFileRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.GetFileRes>(future, fileRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcVoid> setFile(FileInfo fileInfo, boolean close) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: setFile, id " + fileInfo.getFd() + ", close " + close);
        }
        RpcRequestMessage.SetFileReq setFileReq = new RpcRequestMessage.SetFileReq(fileInfo, close);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(setFileReq);
        request.setCommand((short)3);
        RpcResponseMessage.VoidRes voidRes = new RpcResponseMessage.VoidRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(voidRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.VoidRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.VoidRes>(future, voidRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcDeleteFile> removeFile(FileName filename, boolean recursive) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: removeFile");
        }
        RpcRequestMessage.RemoveFileReq removeReq = new RpcRequestMessage.RemoveFileReq(filename, recursive);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(removeReq);
        request.setCommand((short)4);
        RpcResponseMessage.DeleteFileRes fileRes = new RpcResponseMessage.DeleteFileRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(fileRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.DeleteFileRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.DeleteFileRes>(future, fileRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcRenameFile> renameFile(FileName srcHash, FileName dstHash) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: renameFile");
        }
        RpcRequestMessage.RenameFileReq renameReq = new RpcRequestMessage.RenameFileReq(srcHash, dstHash);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(renameReq);
        request.setCommand((short)5);
        RpcResponseMessage.RenameRes renameRes = new RpcResponseMessage.RenameRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(renameRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.RenameRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.RenameRes>(future, renameRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcGetBlock> getBlock(long fd, long token, long position, long capacity) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: getBlock, fd " + fd + ", token " + token + ", position " + position + ", capacity " + capacity);
        }
        RpcRequestMessage.GetBlockReq getBlockReq = new RpcRequestMessage.GetBlockReq(fd, token, position, capacity);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(getBlockReq);
        request.setCommand((short)6);
        RpcResponseMessage.GetBlockRes getBlockRes = new RpcResponseMessage.GetBlockRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(getBlockRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.GetBlockRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.GetBlockRes>(future, getBlockRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcGetLocation> getLocation(FileName fileName, long position) throws IOException {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: getLocation, position " + position);
        }
        RpcRequestMessage.GetLocationReq getLocationReq = new RpcRequestMessage.GetLocationReq(fileName, position);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(getLocationReq);
        request.setCommand((short)7);
        RpcResponseMessage.GetLocationRes getLocationRes = new RpcResponseMessage.GetLocationRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(getLocationRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.GetLocationRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.GetLocationRes>(future, getLocationRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcVoid> setBlock(BlockInfo blockInfo) throws Exception {
        if (CrailConstants.DEBUG) {
            LOG.debug("RPC: setBlock, ");
        }
        RpcRequestMessage.SetBlockReq setBlockReq = new RpcRequestMessage.SetBlockReq(blockInfo);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(setBlockReq);
        request.setCommand((short)8);
        RpcResponseMessage.VoidRes voidRes = new RpcResponseMessage.VoidRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(voidRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.VoidRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.VoidRes>(future, voidRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcGetDataNode> getDataNode(DataNodeInfo dnInfo) throws Exception {
        RpcRequestMessage.GetDataNodeReq getDataNodeReq = new RpcRequestMessage.GetDataNodeReq(dnInfo);
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(getDataNodeReq);
        request.setCommand((short)12);
        RpcResponseMessage.GetDataNodeRes getDataNodeRes = new RpcResponseMessage.GetDataNodeRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(getDataNodeRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.GetDataNodeRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.GetDataNodeRes>(future, getDataNodeRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcVoid> dumpNameNode() throws Exception {
        RpcRequestMessage.DumpNameNodeReq dumpNameNodeReq = new RpcRequestMessage.DumpNameNodeReq();
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(dumpNameNodeReq);
        request.setCommand((short)10);
        RpcResponseMessage.VoidRes voidRes = new RpcResponseMessage.VoidRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(voidRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.VoidRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.VoidRes>(future, voidRes);
        return nameNodeFuture;
    }

    public DaRPCNameNodeFuture<RpcPing> pingNameNode() throws Exception {
        RpcRequestMessage.PingNameNodeReq pingReq = new RpcRequestMessage.PingNameNodeReq();
        DaRPCNameNodeRequest request = new DaRPCNameNodeRequest(pingReq);
        request.setCommand((short)11);
        RpcResponseMessage.PingNameNodeRes pingRes = new RpcResponseMessage.PingNameNodeRes();
        DaRPCNameNodeResponse response = new DaRPCNameNodeResponse(pingRes);
        DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> future = this.issueRPC(request, response);
        DaRPCNameNodeFuture<RpcResponseMessage.PingNameNodeRes> nameNodeFuture = new DaRPCNameNodeFuture<RpcResponseMessage.PingNameNodeRes>(future, pingRes);
        return nameNodeFuture;
    }

    public void close() throws Exception {
        if (this.rpcEndpoint != null) {
            this.rpcEndpoint.close();
            this.rpcEndpoint = null;
        }
    }

    private DaRPCFuture<DaRPCNameNodeRequest, DaRPCNameNodeResponse> issueRPC(DaRPCNameNodeRequest request, DaRPCNameNodeResponse response) throws IOException {
        try {
            DaRPCFuture future = this.stream.request((DaRPCMessage)request, (DaRPCMessage)response, false);
            return future;
        }
        catch (IOException e) {
            LOG.info("ERROR: RPC failed, messagesSend " + this.rpcEndpoint.getMessagesSent() + ", messagesReceived " + this.rpcEndpoint.getMessagesReceived() + ", isConnected " + this.rpcEndpoint.isConnected() + ", qpNum " + this.rpcEndpoint.getQp().getQp_num());
            throw e;
        }
    }

    public String toString() {
        try {
            return this.rpcEndpoint.getDstAddr().toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

