/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode.rpc.tcp;

import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCServerEndpoint;
import com.ibm.narpc.NaRPCServerGroup;
import com.ibm.narpc.NaRPCService;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeRequest;
import org.apache.crail.namenode.rpc.tcp.TcpNameNodeResponse;
import org.apache.crail.namenode.rpc.tcp.TcpRpcConstants;
import org.apache.crail.namenode.rpc.tcp.TcpRpcDispatcher;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcServer;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpNameNodeServer
extends RpcServer {
    private static final Logger LOG = CrailUtils.getLogger();
    private TcpRpcDispatcher dispatcher;
    private NaRPCServerGroup<TcpNameNodeRequest, TcpNameNodeResponse> serverGroup;
    private NaRPCServerEndpoint<TcpNameNodeRequest, TcpNameNodeResponse> serverEndpoint;

    public TcpNameNodeServer(RpcNameNodeService service) throws IOException {
        this.dispatcher = new TcpRpcDispatcher(service);
    }

    public void init(CrailConfiguration conf, String[] arg1) throws Exception {
        TcpRpcConstants.updateConstants(conf);
        TcpRpcConstants.verify();
        this.serverGroup = new NaRPCServerGroup((NaRPCService)this.dispatcher, TcpRpcConstants.NAMENODE_TCP_QUEUEDEPTH, TcpRpcConstants.NAMENODE_TCP_MESSAGESIZE, true, TcpRpcConstants.NAMENODE_TCP_CORES);
        this.serverEndpoint = this.serverGroup.createServerEndpoint();
        InetSocketAddress inetSocketAddress = CrailUtils.getNameNodeAddress();
        this.serverEndpoint.bind(inetSocketAddress);
    }

    public void printConf(Logger logger) {
        TcpRpcConstants.printConf(logger);
    }

    public void run() {
        try {
            while (true) {
                NaRPCServerChannel endpoint = this.serverEndpoint.accept();
                LOG.info("new connection from " + endpoint.address());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

