/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.rpc;

import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.crail.CrailNodeType;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.rpc.RpcProtocol;

public class RpcRequestMessage {

    public static class PingNameNodeReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = 4;
        protected int op = 0;

        public int getOp() {
            return this.op;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 11;
        }

        public int write(ByteBuffer buffer) {
            buffer.putInt(this.op);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.op = buffer.getInt();
        }
    }

    public static class DumpNameNodeReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = 4;
        protected int op = 0;

        public int getOp() {
            return this.op;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 10;
        }

        public int write(ByteBuffer buffer) {
            buffer.putInt(this.op);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.op = buffer.getInt();
        }
    }

    public static class GetDataNodeReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = 20;
        protected DataNodeInfo dnInfo;

        public GetDataNodeReq() {
            this.dnInfo = new DataNodeInfo();
        }

        public GetDataNodeReq(DataNodeInfo dnInfo) {
            this.dnInfo = dnInfo;
        }

        public DataNodeInfo getInfo() {
            return this.dnInfo;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 12;
        }

        public int write(ByteBuffer buffer) {
            int written = this.dnInfo.write(buffer);
            return written;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.dnInfo.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }

    public static class SetBlockReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = BlockInfo.CSIZE;
        protected BlockInfo blockInfo;

        public SetBlockReq() {
            this.blockInfo = new BlockInfo();
        }

        public SetBlockReq(BlockInfo blockInfo) {
            this.blockInfo = blockInfo;
        }

        public BlockInfo getBlockInfo() throws Exception {
            return this.blockInfo;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 8;
        }

        public int write(ByteBuffer buffer) {
            int written = this.blockInfo.write(buffer);
            return written;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.blockInfo.update(buffer);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return "SetBlockReq [blockInfo=" + this.blockInfo + "]";
        }
    }

    public static class GetLocationReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = FileName.CSIZE + 8;
        protected FileName fileName;
        protected long position;

        public GetLocationReq() {
            this.fileName = new FileName();
            this.position = 0L;
        }

        public GetLocationReq(FileName fileName, long position) {
            this.fileName = fileName;
            this.position = position;
        }

        public long getPosition() {
            return this.position;
        }

        public FileName getFileName() {
            return this.fileName;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 7;
        }

        public int write(ByteBuffer buffer) {
            this.fileName.write(buffer);
            buffer.putLong(this.position);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.fileName.update(buffer);
            this.position = buffer.getLong();
        }
    }

    public static class GetBlockReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = 32;
        protected long fd;
        protected long token;
        protected long position;
        protected long capacity;

        public GetBlockReq() {
            this.fd = 0L;
            this.token = 0L;
            this.position = 0L;
            this.capacity = 0L;
        }

        public GetBlockReq(long fd, long token, long position, long capacity) {
            this.fd = fd;
            this.token = token;
            this.position = position;
            this.capacity = capacity;
        }

        public long getFd() {
            return this.fd;
        }

        public long getPosition() {
            return this.position;
        }

        public long getToken() {
            return this.token;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 6;
        }

        public int write(ByteBuffer buffer) {
            buffer.putLong(this.fd);
            buffer.putLong(this.token);
            buffer.putLong(this.position);
            buffer.putLong(this.capacity);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.fd = buffer.getLong();
            this.token = buffer.getLong();
            this.position = buffer.getLong();
            this.capacity = buffer.getLong();
        }

        public String toString() {
            return "GetBlockReq [fd=" + this.fd + ", token=" + this.token + ", position=" + this.position + ", capacity=" + this.capacity + "]";
        }

        public void setToken(long value) {
            this.token = value;
        }
    }

    public static class RenameFileReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = FileName.CSIZE * 2;
        protected FileName srcFileName;
        protected FileName dstFileName;

        public RenameFileReq() {
            this.srcFileName = new FileName();
            this.dstFileName = new FileName();
        }

        public RenameFileReq(FileName srcFileName, FileName dstFileName) {
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
        }

        public FileName getSrcFileName() {
            return this.srcFileName;
        }

        public FileName getDstFileName() {
            return this.dstFileName;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 5;
        }

        public int write(ByteBuffer buffer) {
            int written = this.srcFileName.write(buffer);
            return written += this.dstFileName.write(buffer);
        }

        public void update(ByteBuffer buffer) {
            this.srcFileName.update(buffer);
            this.dstFileName.update(buffer);
        }

        public String toString() {
            return "RenameFileReq [srcFileName=" + this.srcFileName + ", dstFileName=" + this.dstFileName + "]";
        }
    }

    public static class RemoveFileReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = FileName.CSIZE + 4;
        protected FileName filename;
        protected boolean recursive;

        public RemoveFileReq() {
            this.filename = new FileName();
            this.recursive = false;
        }

        public RemoveFileReq(FileName filename, boolean recursive) {
            this.filename = filename;
            this.recursive = recursive;
        }

        public FileName getFileName() {
            return this.filename;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 4;
        }

        public int write(ByteBuffer buffer) {
            this.filename.write(buffer);
            buffer.putInt(this.recursive ? 1 : 0);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.filename.update(buffer);
            int tmp = buffer.getInt();
            this.recursive = tmp == 1;
        }
    }

    public static class SetFileReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = 48;
        protected FileInfo fileInfo;
        protected boolean close;

        public SetFileReq() {
            this.fileInfo = new FileInfo();
            this.close = false;
        }

        public SetFileReq(FileInfo fileInfo, boolean close) {
            this.fileInfo = fileInfo;
            this.close = close;
        }

        public FileInfo getFileInfo() {
            return this.fileInfo;
        }

        public boolean isClose() {
            return this.close;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 3;
        }

        public int write(ByteBuffer buffer) {
            this.fileInfo.write(buffer, true);
            buffer.putInt(this.close ? 1 : 0);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            try {
                this.fileInfo.update(buffer);
                int tmp = buffer.getInt();
                this.close = tmp == 1;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return "SetFileReq [fileInfo=" + this.fileInfo + ", close=" + this.close + "]";
        }
    }

    public static class GetFileReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = FileName.CSIZE + 4;
        protected FileName filename;
        protected boolean writeable;

        public GetFileReq() {
            this.filename = new FileName();
            this.writeable = false;
        }

        public GetFileReq(FileName filename, boolean writeable) {
            this.filename = filename;
            this.writeable = writeable;
        }

        public FileName getFileName() {
            return this.filename;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 2;
        }

        public int write(ByteBuffer buffer) {
            this.filename.write(buffer);
            buffer.putInt(this.writeable ? 1 : 0);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.filename.update(buffer);
            int tmp = buffer.getInt();
            this.writeable = tmp == 1;
        }
    }

    public static class CreateFileReq
    implements RpcProtocol.NameNodeRpcMessage {
        public static int CSIZE = FileName.CSIZE + 16;
        protected FileName filename;
        protected CrailNodeType type;
        protected int storageClass;
        protected int locationClass;
        protected boolean enumerable;

        public CreateFileReq() {
            this.filename = new FileName();
            this.type = CrailNodeType.DATAFILE;
            this.storageClass = 0;
            this.locationClass = 0;
            this.enumerable = true;
        }

        public CreateFileReq(FileName filename, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) {
            this.filename = filename;
            this.type = type;
            this.storageClass = storageClass;
            this.locationClass = locationClass;
            this.enumerable = enumerable;
        }

        public FileName getFileName() {
            return this.filename;
        }

        public CrailNodeType getFileType() {
            return this.type;
        }

        public int getStorageClass() {
            return this.storageClass;
        }

        public int getLocationClass() {
            return this.locationClass;
        }

        public boolean isEnumerable() {
            return this.enumerable;
        }

        public int size() {
            return CSIZE;
        }

        @Override
        public short getType() {
            return 1;
        }

        public int write(ByteBuffer buffer) {
            this.filename.write(buffer);
            buffer.putInt(this.type.getLabel());
            buffer.putInt(this.storageClass);
            buffer.putInt(this.locationClass);
            buffer.putInt(this.enumerable ? 1 : 0);
            return CSIZE;
        }

        public void update(ByteBuffer buffer) {
            this.filename.update(buffer);
            int _type = buffer.getInt();
            this.type = CrailNodeType.parse((int)_type);
            this.storageClass = buffer.getInt();
            this.locationClass = buffer.getInt();
            int _enumerable = buffer.getInt();
            this.enumerable = _enumerable == 1;
        }

        public String toString() {
            return "CreateFileReq [filename=" + this.filename + ", type=" + this.type + ", storageClass=" + this.storageClass + ", locationClass=" + this.locationClass + ", enumerable=" + this.enumerable + "]";
        }
    }
}

