/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.tcp;

import com.ibm.narpc.NaRPCClientGroup;
import com.ibm.narpc.NaRPCEndpoint;
import java.io.IOException;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageClient;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.tcp.TcpStorageConstants;
import org.apache.crail.storage.tcp.TcpStorageEndpoint;
import org.apache.crail.storage.tcp.TcpStorageRequest;
import org.apache.crail.storage.tcp.TcpStorageResponse;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class TcpStorageClient
implements StorageClient {
    private NaRPCClientGroup<TcpStorageRequest, TcpStorageResponse> clientGroup;

    public void init(CrailStatistics statistics, CrailBufferCache bufferCache, CrailConfiguration conf, String[] args) throws IOException {
        TcpStorageConstants.updateConstants(conf);
        this.clientGroup = new NaRPCClientGroup(TcpStorageConstants.STORAGE_TCP_QUEUE_DEPTH, (int)CrailConstants.BLOCK_SIZE * 2, false);
    }

    public void printConf(Logger logger) {
        TcpStorageConstants.printConf(logger);
    }

    public void close() throws Exception {
    }

    public StorageEndpoint createEndpoint(DataNodeInfo info) throws IOException {
        try {
            NaRPCEndpoint narpcEndpoint = this.clientGroup.createEndpoint();
            TcpStorageEndpoint endpoint = new TcpStorageEndpoint((NaRPCEndpoint<TcpStorageRequest, TcpStorageResponse>)narpcEndpoint);
            endpoint.connect(CrailUtils.datanodeInfo2SocketAddr((DataNodeInfo)info));
            return endpoint;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

