/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.tcp;

import com.ibm.narpc.NaRPCMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.crail.conf.CrailConstants;

public class TcpStorageRequest
implements NaRPCMessage {
    public static final int HEADER_SIZE = 4;
    public static final int CSIZE = 4 + Math.max(WriteRequest.CSIZE, 16);
    private int type;
    private WriteRequest writeRequest;
    private ReadRequest readRequest;

    public TcpStorageRequest() {
        this.writeRequest = new WriteRequest();
        this.readRequest = new ReadRequest();
    }

    public TcpStorageRequest(WriteRequest writeRequest) {
        this.writeRequest = writeRequest;
        this.type = 2;
    }

    public TcpStorageRequest(ReadRequest readRequest) {
        this.readRequest = readRequest;
        this.type = 1;
    }

    public int size() {
        return CSIZE;
    }

    public int type() {
        return this.type;
    }

    public void update(ByteBuffer buffer) throws IOException {
        this.type = buffer.getInt();
        if (this.type == 2) {
            this.writeRequest.update(buffer);
        } else if (this.type == 1) {
            this.readRequest.update(buffer);
        }
    }

    public int write(ByteBuffer buffer) throws IOException {
        buffer.putInt(this.type);
        int written = 4;
        if (this.type == 2) {
            written += this.writeRequest.write(buffer);
        } else if (this.type == 1) {
            written += this.readRequest.write(buffer);
        }
        return written;
    }

    public WriteRequest getWriteRequest() {
        return this.writeRequest;
    }

    public ReadRequest getReadRequest() {
        return this.readRequest;
    }

    public static class ReadRequest {
        public static final int CSIZE = 16;
        private int key;
        private long address;
        private int length;

        public ReadRequest() {
        }

        public ReadRequest(int key, long address, int length) {
            this.key = key;
            this.address = address;
            this.length = length;
        }

        public long getAddress() {
            return this.address;
        }

        public int length() {
            return this.length;
        }

        public int getKey() {
            return this.key;
        }

        public int size() {
            return 16;
        }

        public void update(ByteBuffer buffer) throws IOException {
            this.key = buffer.getInt();
            this.address = buffer.getLong();
            this.length = buffer.getInt();
        }

        public int write(ByteBuffer buffer) throws IOException {
            buffer.putInt(this.key);
            buffer.putLong(this.address);
            buffer.putInt(this.length);
            return 16;
        }
    }

    public static class WriteRequest {
        public static final int FIELDS_SIZE = 16;
        public static final int CSIZE = 20 + (int)CrailConstants.BLOCK_SIZE;
        private int key;
        private long address;
        private int length;
        private ByteBuffer data;

        public WriteRequest() {
            this.data = ByteBuffer.allocateDirect((int)CrailConstants.BLOCK_SIZE);
        }

        public WriteRequest(int key, long address, int length, ByteBuffer buffer) {
            this.key = key;
            this.address = address;
            this.length = length;
            this.data = buffer;
        }

        public long getAddress() {
            return this.address;
        }

        public int length() {
            return this.length;
        }

        public int getKey() {
            return this.key;
        }

        public ByteBuffer getBuffer() {
            return this.data;
        }

        public int size() {
            return CSIZE;
        }

        public void update(ByteBuffer buffer) throws IOException {
            this.key = buffer.getInt();
            this.address = buffer.getLong();
            this.length = buffer.getInt();
            int remaining = buffer.getInt();
            buffer.limit(buffer.position() + remaining);
            this.data.clear();
            this.data.put(buffer);
            this.data.flip();
        }

        public int write(ByteBuffer buffer) throws IOException {
            buffer.putInt(this.key);
            buffer.putLong(this.address);
            buffer.putInt(this.length);
            buffer.putInt(this.data.remaining());
            int written = 20 + this.data.remaining();
            buffer.put(this.data);
            return written;
        }
    }
}

