/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.tcp;

import com.ibm.narpc.NaRPCMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.storage.tcp.TcpStorageRequest;

public class TcpStorageResponse
implements NaRPCMessage {
    public static final int HEADER_SIZE = 8;
    public static final int CSIZE = 8 + Math.max(TcpStorageRequest.WriteRequest.CSIZE, 16);
    private int error;
    private int type;
    private WriteResponse writeResponse;
    private ReadResponse readResponse;

    public TcpStorageResponse(WriteResponse writeResponse) {
        this.writeResponse = writeResponse;
        this.type = 2;
        this.error = 0;
    }

    public TcpStorageResponse(ReadResponse readResponse) {
        this.readResponse = readResponse;
        this.type = 1;
        this.error = 0;
    }

    public TcpStorageResponse(int error) {
        this.error = error;
    }

    public int size() {
        return CSIZE;
    }

    public void update(ByteBuffer buffer) throws IOException {
        this.error = buffer.getInt();
        this.type = buffer.getInt();
        if (this.type == 2) {
            this.writeResponse.update(buffer);
        } else if (this.type == 1) {
            this.readResponse.update(buffer);
        }
    }

    public int write(ByteBuffer buffer) throws IOException {
        buffer.putInt(this.error);
        buffer.putInt(this.type);
        int written = 8;
        if (this.type == 2) {
            written += this.writeResponse.write(buffer);
        } else if (this.type == 1) {
            written += this.readResponse.write(buffer);
        }
        return written;
    }

    public static class ReadResponse {
        public static final int CSIZE = 4 + (int)CrailConstants.BLOCK_SIZE;
        private ByteBuffer data;

        public ReadResponse(ByteBuffer data) {
            this.data = data;
        }

        public int write(ByteBuffer buffer) throws IOException {
            int written = this.data.remaining();
            buffer.putInt(this.data.remaining());
            buffer.put(this.data);
            return 4 + written;
        }

        public void update(ByteBuffer buffer) throws IOException {
            int remaining = buffer.getInt();
            this.data.clear().limit(remaining);
            buffer.limit(buffer.position() + remaining);
            this.data.put(buffer);
        }

        public int size() {
            return CSIZE;
        }
    }

    public static class WriteResponse {
        private int size;

        public WriteResponse() {
        }

        public WriteResponse(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public void update(ByteBuffer buffer) throws IOException {
            this.size = buffer.getInt();
        }

        public int write(ByteBuffer buffer) throws IOException {
            buffer.putInt(this.size);
            return 4;
        }
    }
}

