/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.orc;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.MapFn;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.orc.OrcFileSource;
import org.apache.crunch.io.orc.OrcWritable;
import org.apache.crunch.types.PType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class OrcFileReaderFactory<T>
implements FileReaderFactory<T> {
    private MapFn<Object, T> inputFn;
    private OrcInputFormat inputFormat = new OrcInputFormat();
    private int[] readColumns;

    public OrcFileReaderFactory(PType<T> ptype) {
        this(ptype, null);
    }

    public OrcFileReaderFactory(PType<T> ptype, int[] readColumns) {
        this.inputFn = ptype.getInputMapFn();
        this.readColumns = readColumns;
    }

    public Iterator<T> read(FileSystem fs, final Path path) {
        try {
            if (!fs.isFile(path)) {
                throw new CrunchRuntimeException("Not a file: " + path);
            }
            this.inputFn.initialize();
            FileStatus status = fs.getFileStatus(path);
            FileSplit split = new FileSplit(path, 0L, status.getLen(), new String[0]);
            JobConf conf = new JobConf();
            if (this.readColumns != null) {
                conf.setBoolean("hive.io.file.read.all.columns", false);
                conf.set("hive.io.file.readcolumn.ids", OrcFileSource.getColumnIdsStr(this.readColumns));
            }
            final RecordReader reader = this.inputFormat.getRecordReader((InputSplit)split, conf, Reporter.NULL);
            return new UnmodifiableIterator<T>(){
                private boolean checked = false;
                private boolean hasNext;
                private OrcStruct value;
                private OrcWritable writable = new OrcWritable();

                public boolean hasNext() {
                    try {
                        if (this.value == null) {
                            this.value = (OrcStruct)reader.createValue();
                        }
                        if (!this.checked) {
                            this.hasNext = reader.next((Object)NullWritable.get(), (Object)this.value);
                            this.checked = true;
                        }
                        return this.hasNext;
                    }
                    catch (Exception e) {
                        throw new CrunchRuntimeException("Error while reading local file: " + path, e);
                    }
                }

                public T next() {
                    try {
                        if (this.value == null) {
                            this.value = (OrcStruct)reader.createValue();
                        }
                        if (!this.checked) {
                            reader.next((Object)NullWritable.get(), (Object)this.value);
                        }
                        this.checked = false;
                        this.writable.set(this.value);
                        return OrcFileReaderFactory.this.inputFn.map((Object)this.writable);
                    }
                    catch (Exception e) {
                        throw new CrunchRuntimeException("Error while reading local file: " + path, e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new CrunchRuntimeException("Error while reading local file: " + path, e);
        }
    }
}

