/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.orc;

import java.io.Closeable;
import java.io.IOException;
import org.apache.crunch.MapFn;
import org.apache.crunch.io.orc.OrcWritable;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class OrcFileWriter<T>
implements Closeable {
    private RecordWriter<NullWritable, Object> writer;
    private MapFn<T, Object> mapFn;
    private final OrcSerde serde;

    public OrcFileWriter(Configuration conf, Path path, PType<T> pType) throws IOException {
        JobConf jobConf = new JobConf(conf);
        OrcOutputFormat outputFormat = new OrcOutputFormat();
        this.writer = outputFormat.getRecordWriter(null, jobConf, path.toString(), (Progressable)new NullProgress());
        this.mapFn = pType.getOutputMapFn();
        this.mapFn.initialize();
        this.serde = new OrcSerde();
    }

    public void write(T t) throws IOException {
        OrcWritable ow = (OrcWritable)this.mapFn.map(t);
        if (ow.get() == null) {
            throw new NullPointerException("Cannot write null records to orc file");
        }
        this.writer.write((Object)NullWritable.get(), (Object)this.serde.serialize((Object)ow.get(), ow.getObjectInspector()));
    }

    @Override
    public void close() throws IOException {
        this.writer.close(Reporter.NULL);
    }

    static class NullProgress
    implements Progressable {
        NullProgress() {
        }

        public void progress() {
        }
    }
}

