/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.types.orc.OrcUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class OrcWritable
implements WritableComparable<OrcWritable> {
    private OrcStruct orc;
    private ObjectInspector oi;
    private BytesWritable blob;
    private BinarySortableSerDe serde;

    public void write(DataOutput out) throws IOException {
        this.serialize();
        this.blob.write(out);
    }

    private void serialize() {
        try {
            if (this.blob == null) {
                byte[] bytes = ((BytesWritable)this.serde.serialize((Object)this.orc, this.oi)).getBytes();
                byte[] newBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                this.blob = new BytesWritable(newBytes);
            }
        }
        catch (SerDeException e) {
            throw new CrunchRuntimeException("Unable to serialize object: " + this.orc);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.blob = new BytesWritable();
        this.blob.readFields(in);
        this.orc = null;
    }

    public int compareTo(OrcWritable arg0) {
        this.serialize();
        arg0.serialize();
        return this.blob.compareTo(arg0.blob);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((OrcWritable)obj) == 0;
    }

    public int hashCode() {
        return this.blob == null ? 0 : this.blob.hashCode();
    }

    public void setSerde(BinarySortableSerDe serde) {
        this.serde = serde;
    }

    public void setObjectInspector(ObjectInspector oi) {
        this.oi = oi;
    }

    public ObjectInspector getObjectInspector() {
        return this.oi;
    }

    public void set(OrcStruct orcStruct) {
        this.orc = orcStruct;
        this.blob = null;
    }

    public OrcStruct get() {
        if (this.orc == null && this.blob != null) {
            this.makeOrcStruct();
        }
        return this.orc;
    }

    private void makeOrcStruct() {
        try {
            Object row = this.serde.deserialize((Writable)this.blob);
            StructObjectInspector rowOi = (StructObjectInspector)this.serde.getObjectInspector();
            this.orc = (OrcStruct)OrcUtils.convert(row, (ObjectInspector)rowOi, this.oi);
        }
        catch (SerDeException e) {
            throw new CrunchRuntimeException("Unable to deserialize blob: " + this.blob);
        }
    }
}

