/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.orc;

import java.io.IOException;
import org.apache.crunch.io.orc.OrcWritable;
import org.apache.hadoop.hive.ql.io.orc.OrcNewOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class OrcCrunchOutputFormat
extends FileOutputFormat<NullWritable, OrcWritable> {
    private OrcNewOutputFormat outputFormat = new OrcNewOutputFormat();

    public RecordWriter<NullWritable, OrcWritable> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        RecordWriter writer = this.outputFormat.getRecordWriter(job);
        return new OrcCrunchRecordWriter((RecordWriter<NullWritable, Writable>)writer);
    }

    static class OrcCrunchRecordWriter
    extends RecordWriter<NullWritable, OrcWritable> {
        private final RecordWriter<NullWritable, Writable> writer;
        private final OrcSerde orcSerde;

        OrcCrunchRecordWriter(RecordWriter<NullWritable, Writable> writer) {
            this.writer = writer;
            this.orcSerde = new OrcSerde();
        }

        public void write(NullWritable key, OrcWritable value) throws IOException, InterruptedException {
            if (value.get() == null) {
                throw new NullPointerException("Cannot write null records to orc file");
            }
            this.writer.write((Object)key, (Object)this.orcSerde.serialize((Object)value.get(), value.getObjectInspector()));
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.writer.close(context);
        }
    }
}

