/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.orc;

import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.crunch.Tuple;
import org.apache.crunch.Union;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.TupleFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class TupleObjectInspector<T extends Tuple>
extends StructObjectInspector {
    private TupleFactory<T> tupleFactory;
    private List<TupleField> fields;

    public TupleObjectInspector(TupleFactory<T> tupleFactory, PType ... ptypes) {
        this.tupleFactory = tupleFactory;
        this.fields = new ArrayList<TupleField>();
        for (int i = 0; i < ptypes.length; ++i) {
            TupleField field = new TupleField(i, ptypes[i]);
            this.fields.add(field);
        }
    }

    public String getTypeName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("struct<");
        for (int i = 0; i < this.fields.size(); ++i) {
            StructField field = this.fields.get(i);
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(field.getFieldName());
            buffer.append(":");
            buffer.append(field.getFieldObjectInspector().getTypeName());
        }
        buffer.append(">");
        return buffer.toString();
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public T create(Object ... values) {
        return (T)this.tupleFactory.makeTuple(values);
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    public StructField getStructFieldRef(String fieldName) {
        for (StructField structField : this.fields) {
            if (!structField.getFieldName().equals(fieldName)) continue;
            return structField;
        }
        return null;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        TupleField field = (TupleField)fieldRef;
        return ((Tuple)data).get(field.index);
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        Tuple tuple = (Tuple)data;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < tuple.size(); ++i) {
            result.add(tuple.get(i));
        }
        return result;
    }

    static class ByteBufferObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements SettableBinaryObjectInspector {
        ByteBufferObjectInspector() {
            super(TypeInfoFactory.binaryTypeInfo);
        }

        public ByteBuffer copyObject(Object o) {
            if (o == null) {
                return null;
            }
            byte[] oldBytes = this.getPrimitiveJavaObject(o);
            byte[] copiedBytes = new byte[oldBytes.length];
            System.arraycopy(oldBytes, 0, copiedBytes, 0, oldBytes.length);
            ByteBuffer duplicate = ByteBuffer.wrap(copiedBytes);
            return duplicate;
        }

        public BytesWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            ByteBuffer buf = (ByteBuffer)o;
            BytesWritable bw = new BytesWritable();
            bw.set(buf.array(), buf.arrayOffset(), buf.limit());
            return bw;
        }

        public byte[] getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            ByteBuffer buf = (ByteBuffer)o;
            byte[] b = new byte[buf.limit()];
            System.arraycopy(buf.array(), buf.arrayOffset(), b, 0, b.length);
            return b;
        }

        public Object set(Object o, byte[] b) {
            throw new UnsupportedOperationException("set is not supported");
        }

        public Object set(Object o, BytesWritable bw) {
            throw new UnsupportedOperationException("set is not supported");
        }

        public ByteBuffer create(byte[] bb) {
            return bb == null ? null : ByteBuffer.wrap(bb);
        }

        public ByteBuffer create(BytesWritable bw) {
            return bw == null ? null : ByteBuffer.wrap(bw.getBytes());
        }
    }

    static class TupleField
    implements StructField {
        private int index;
        private ObjectInspector oi;

        public TupleField(int index, PType<?> ptype) {
            this.index = index;
            this.oi = this.createObjectInspector(ptype);
        }

        private ObjectInspector createObjectInspector(PType<?> ptype) {
            Object result;
            Class typeClass = ptype.getTypeClass();
            if (typeClass == Union.class || typeClass == Void.class) {
                throw new IllegalArgumentException(typeClass.getName() + " is not supported yet");
            }
            if (typeClass == ByteBuffer.class) {
                result = new ByteBufferObjectInspector();
            } else if (typeClass == Collection.class) {
                ObjectInspector itemOi = this.createObjectInspector((PType)ptype.getSubTypes().get(0));
                result = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)itemOi);
            } else if (typeClass == Map.class) {
                ObjectInspector keyOi = ObjectInspectorFactory.getReflectionObjectInspector(String.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                ObjectInspector valueOi = this.createObjectInspector((PType)ptype.getSubTypes().get(0));
                result = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyOi, (ObjectInspector)valueOi);
            } else {
                result = Tuple.class.isAssignableFrom(typeClass) ? new TupleObjectInspector(TupleFactory.getTupleFactory((Class)typeClass), ptype.getSubTypes().toArray(new PType[0])) : ObjectInspectorFactory.getReflectionObjectInspector((Type)typeClass, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            }
            return result;
        }

        public String getFieldName() {
            return "_col" + this.index;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.oi;
        }

        public int getFieldID() {
            return this.index;
        }

        public String getFieldComment() {
            return null;
        }
    }
}

