/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.pear.tools.PackageCreator;
import org.apache.uima.pear.tools.PackageCreatorException;

public class BuildPear {
    public static void main(String[] args) {
        String tmpDir;
        String targetDir;
        String parent;
        File cwd = new File(".");
        String componentRootDir = "";
        String componentId = "";
        File cwdCanonical = null;
        try {
            cwdCanonical = cwd.getCanonicalFile();
            componentId = cwdCanonical.getName();
        }
        catch (IOException ioe) {
            System.err.println();
            System.err.println("Error accessing current directory.");
            ioe.printStackTrace(System.err);
        }
        if (args.length == 1) {
            componentId = args[0];
        }
        if ((parent = cwdCanonical.getParent()) == null) {
            System.err.println("Error accessing current directory " + cwdCanonical);
        }
        System.out.println("Building PEAR for " + componentId + " using");
        String propsFn = "/" + BuildPear.class.getPackage().getName().replace('.', '/') + "/BuildPear." + componentId + ".properties";
        try {
            propsFn = BuildPear.class.getResource(propsFn).toURI().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File componentRoot = new File(parent, componentId);
        componentRootDir = parent + File.separator + componentId;
        File p = new File(propsFn);
        System.out.println(p.getAbsolutePath());
        Properties props = new Properties();
        String classpathDefault = "$main_root/bin;$main_root/../ctakes-core/bin;";
        String datapathDefault = "$main_root/resources;";
        String aeDescriptorDefault = "desc/AE.xml";
        String classpath = "$main_root/bin;$main_root/../ctakes-core/bin;";
        String datapath = "$main_root/resources;";
        String aeDescriptor = "desc/AE.xml";
        try {
            FileInputStream fis = new FileInputStream(p);
            props.load(fis);
            classpath = props.getProperty("classpath", "$main_root/bin;$main_root/../ctakes-core/bin;");
            datapath = props.getProperty("datapath", "$main_root/resources;");
            aeDescriptor = props.getProperty("aeDescriptor", "desc/AE.xml");
            componentId = props.getProperty("project");
        }
        catch (IOException ioe) {
            System.out.println();
            System.out.println(BuildPear.quote(propsFn) + " not found, using defaults for " + componentId);
        }
        if (!new File(componentRoot, aeDescriptor).exists()) {
            System.err.println();
            System.err.println("Unable to create or access " + aeDescriptor);
            System.exit(-1);
        }
        String string = targetDir = (tmpDir = System.getProperty("java.io.tmpdir")).endsWith(File.separator) ? tmpDir + "BuildPear" : tmpDir + File.separator + "BuildPear";
        if (!BuildPear.createDirIfNotExist(targetDir)) {
            System.err.println();
            System.err.println("Unable to create or access " + targetDir);
            System.exit(-1);
        }
        System.out.println("Building PEAR file for " + BuildPear.quote(componentId));
        System.out.println("  from " + BuildPear.quote(componentRootDir));
        System.out.println("  setting PEAR classpath =  " + BuildPear.quote(classpath));
        System.out.println("  setting PEAR datapath =  " + BuildPear.quote(datapath));
        System.out.println("  setting PEAR AE descriptor =  " + BuildPear.quote(aeDescriptor));
        try {
            PackageCreator.generatePearPackage((String)componentId, (String)aeDescriptor, (String)classpath, (String)datapath, (String)componentRootDir, (String)targetDir, null);
        }
        catch (PackageCreatorException pce) {
            System.err.println();
            System.err.println("Error trying to package " + componentId);
            pce.printStackTrace(System.err);
        }
        System.out.println("BuildPear completed.");
    }

    public static String quote(String s) {
        if (s == null) {
            return "[null]";
        }
        char DBLQUOTES = '\"';
        String QUOTE = "'";
        if (s.contains(QUOTE)) {
            return DBLQUOTES + s + DBLQUOTES;
        }
        return QUOTE + s + QUOTE;
    }

    public static boolean createDirIfNotExist(String path) {
        try {
            File f = new File(path);
            if (f.exists() && f.isDirectory() && f.canWrite()) {
                return true;
            }
            if (f.mkdir()) {
                return true;
            }
            System.err.println("Unable to create " + path);
            return false;
        }
        catch (SecurityException se) {
            System.err.println("Security problem - unable to create " + path);
            return false;
        }
    }
}

