/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.build;

import java.io.File;
import org.apache.ctakes.utils.build.InstallPearSilently;

public class InstallPipelineFromPears {
    private static String[] projects = new String[]{"core", "document preprocessor", "POS tagger", "chunker", "context dependent tokenizer", "dictionary lookup", "LVG", "NE contexts", "ctakes-clinical-pipeline"};

    public static String getString(String[] a, int i) {
        try {
            return a[i];
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error accessing argument " + i);
            System.err.println("Number of arguments received = " + (a == null ? -1 : a.length));
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String quote(String s) {
        if (s == null) {
            return "[null]";
        }
        char DBLQUOTES = '\"';
        String QUOTE = "'";
        if (s.contains(QUOTE)) {
            return DBLQUOTES + s + DBLQUOTES;
        }
        return QUOTE + s + QUOTE;
    }

    public static void main(String[] args) {
        String pearFileLocation = InstallPipelineFromPears.getString(args, 0);
        String installDir = InstallPipelineFromPears.getString(args, 1);
        if (pearFileLocation == null) {
            System.err.println("Need to give pear file location.");
            System.exit(-1);
        }
        if (installDir == null) {
            System.err.println("Need to give pear file location AND the target directory.");
            System.exit(-1);
        }
        System.out.println("Installing " + projects.length + " PEAR files to " + InstallPipelineFromPears.quote(installDir));
        for (String proj : projects) {
            String pearFn = pearFileLocation + File.separator + proj + ".pear";
            String[] installArgs = new String[]{pearFn, installDir};
            InstallPearSilently.main(installArgs);
        }
        System.out.println("Done installing " + projects.length + " PEAR files to " + InstallPipelineFromPears.quote(installDir));
    }
}

