/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.distsem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.utils.distsem.WordVector;

public class WordEmbeddings {
    private Map<String, WordVector> vectors = null;
    private int dimensionality = 0;

    public WordEmbeddings(int dim) {
        this.vectors = new HashMap<String, WordVector>();
        this.dimensionality = dim;
    }

    public WordEmbeddings(Map<String, WordVector> vectors) {
        this.vectors = vectors;
    }

    public double getSimilarity(String word1, String word2) {
        WordVector vec1 = this.getVector(word1);
        WordVector vec2 = this.getVector(word2);
        assert (vec1.size() == vec2.size());
        double sim = 0.0;
        for (int i = 0; i < vec1.size(); ++i) {
            sim += vec1.getValue(i) * vec2.getValue(i);
        }
        return sim /= vec1.getLength() * vec2.getLength();
    }

    public void add(String line) {
        int wordBreak = line.indexOf(32);
        String word = line.substring(0, wordBreak);
        String[] dims = line.substring(wordBreak + 1).split(" ");
        double[] vector = new double[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            vector[i] = Double.valueOf(dims[i]);
        }
        this.vectors.put(word, new WordVector(word, vector));
    }

    public boolean containsKey(String word) {
        return this.vectors.containsKey(word);
    }

    public WordVector getVector(String word) {
        if (this.vectors != null) {
            return this.vectors.get(word);
        }
        return null;
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public List<String> getSimilarWords(String word, int maxWords) {
        double[] sims = new double[maxWords];
        ArrayList<String> words = new ArrayList<String>(20);
        Arrays.fill(sims, -1.0);
        block0: for (String comp : this.vectors.keySet()) {
            double sim = this.getSimilarity(word, comp);
            if (word.equals(comp)) continue;
            if (words.size() == 0) {
                words.add(comp);
                sims[0] = sim;
                continue;
            }
            if (sim < sims[maxWords - 1]) continue;
            for (int i = Math.min(maxWords - 1, words.size()); i >= 0; --i) {
                if (i > 0 && sim > sims[i - 1]) {
                    sims[i] = sims[i - 1];
                    if (words.size() <= i) {
                        words.add((String)words.get(i - 1));
                        continue;
                    }
                    words.set(i, (String)words.get(i - 1));
                    continue;
                }
                sims[i] = sim;
                if (words.size() <= i) {
                    words.add(comp);
                    continue block0;
                }
                words.set(i, comp);
                continue block0;
            }
        }
        return words;
    }
}

