/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.kernel;

import java.util.concurrent.ConcurrentHashMap;
import libsvm.svm_node;
import org.apache.ctakes.utils.kernel.Kernel;

public class PolyKernel
extends Kernel {
    private int degree;
    private double coef;
    private boolean norm;
    private ConcurrentHashMap<Object, Double> normalizers = new ConcurrentHashMap();

    public PolyKernel(int degree, double coef, boolean norm) {
        this.degree = degree;
        this.coef = coef;
        this.norm = norm;
    }

    public PolyKernel() {
        this.degree = 1;
        this.coef = 0.0;
        this.norm = false;
    }

    @Override
    public double eval(Object o1, Object o2) {
        svm_node[] v1 = (svm_node[])o1;
        svm_node[] v2 = (svm_node[])o2;
        if (this.norm) {
            double norm2;
            double norm1;
            if (!this.normalizers.containsKey(o1)) {
                norm1 = this.sim(v1, v1);
                this.normalizers.put(o1, norm1);
            } else {
                norm1 = this.normalizers.get(o1);
            }
            if (!this.normalizers.containsKey(o2)) {
                norm2 = this.sim(v2, v2);
                this.normalizers.put(o2, norm2);
            } else {
                norm2 = this.normalizers.get(o2);
            }
            return this.sim(v1, v2) / Math.sqrt(norm1 * norm2);
        }
        return this.sim(v1, v2);
    }

    private final double sim(svm_node[] v1, svm_node[] v2) {
        double sim = PolyKernel.dotProd(v1, v2) + this.coef;
        if (this.degree != 1) {
            sim = Math.pow(sim, this.degree);
        }
        return sim;
    }
}

