/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.wiki;

import java.io.IOException;
import java.util.Scanner;
import org.apache.ctakes.utils.wiki.ApproximateMath;
import org.apache.ctakes.utils.wiki.WikiIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;

public class TestCosineSimilarity {
    public static void main(String[] args) throws CorruptIndexException, IOException, ParseException {
        boolean approx = true;
        WikiIndex wikipediaIndex = new WikiIndex(5, "/home/tmill/Documents/wiki/index_med_5k", "text", approx);
        wikipediaIndex.initialize();
        System.out.println("Index loaded... Press enter to continue...");
        Scanner scanner = new Scanner(System.in);
        String line = scanner.nextLine();
        double sim = wikipediaIndex.getCosineSimilarity("the procedure", "continuous Baker Baker dialysis");
        System.out.println("Sim is: " + sim);
        sim = wikipediaIndex.getCosineSimilarity("the procedure", "an orthotic liver transplant");
        System.out.println("Sim is: " + sim);
        sim = wikipediaIndex.getCosineSimilarity("the procedure", "transplant");
        System.out.println("Sim is: " + sim);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            System.out.println("i = " + i);
            if (i == 1) {
                start = System.currentTimeMillis();
            }
            double cosine0 = wikipediaIndex.getCosineSimilarity("heart disease", "microsoft");
            System.out.println("Similarity score: " + cosine0 + " took " + (System.currentTimeMillis() - start) + " ms to compute.");
            double cosine1 = wikipediaIndex.getCosineSimilarity("heart disease", "smoking");
            System.out.println("Similarity score: " + cosine1 + " took " + (System.currentTimeMillis() - start) + " ms to compute.");
            double cosine2 = wikipediaIndex.getCosineSimilarity("aspirin", "tylenol");
            System.out.println("Similarity score: " + cosine2 + " took " + (System.currentTimeMillis() - start) + " ms to compute.");
            double cosine3 = wikipediaIndex.getCosineSimilarity("aspirin", "ibuprofen");
            System.out.println("Similarity score: " + cosine3 + " took " + (System.currentTimeMillis() - start) + " ms to compute.");
            double cosine4 = wikipediaIndex.getCosineSimilarity("advil", "ibuprofen");
            System.out.println("Similarity score: " + cosine4 + " took " + (System.currentTimeMillis() - start) + " ms to compute.");
        }
        System.out.println("10 iterations took: " + (System.currentTimeMillis() - start) + " ms to compute.");
        ApproximateMath.dumpCache();
        wikipediaIndex.close();
    }
}

