/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.xcas_comparison;

import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.ctakes.utils.xcas_comparison.XcasAnnotation;
import org.apache.ctakes.utils.xcas_comparison.XcasProcessor;

public class XcasFile
implements Cloneable {
    protected File f;
    protected Hashtable<Integer, XcasAnnotation> annotations = new Hashtable();
    protected Hashtable<XcasAnnotation, String> positions = new Hashtable();

    public XcasFile() {
    }

    public XcasFile(String f) {
        this();
        this.f = new File(f);
    }

    public XcasFile(File f) {
        this();
        this.f = f;
    }

    public static XcasFile process(String f) {
        return new XcasProcessor().process(f);
    }

    public void addAnnotation(int id, XcasAnnotation a) {
        this.annotations.put(id, a);
    }

    public void addAnnotation(int id, XcasAnnotation a, String pos) {
        this.addAnnotation(id, a);
        this.positions.put(a, pos);
    }

    public void addAnnotation(int id, XcasAnnotation a, int lineNum, int colNum) {
        this.addAnnotation(id, a, Integer.toString(lineNum) + ":" + Integer.toString(colNum));
    }

    public XcasAnnotation getAnnotation(int id) {
        return this.annotations.get(id);
    }

    public Collection<XcasAnnotation> getAllAnnotations() {
        return this.annotations.values();
    }

    public String getFileName() {
        return this.f.getName();
    }

    public String getPositionOwn(XcasAnnotation a) {
        return this.positions.get(a);
    }

    public String getPositionOwn(int id) {
        return this.positions.get(this.annotations.get(id));
    }

    public String getPositionOther(XcasAnnotation a) {
        for (XcasAnnotation o : this.positions.keySet()) {
            if (!o.equals(a)) continue;
            return this.positions.get(o);
        }
        return null;
    }

    public String getPosition(XcasAnnotation a) {
        if (this.positions.keySet().contains(a)) {
            return this.positions.get(a);
        }
        return this.getPositionOther(a);
    }

    public String getPositionSimilar(XcasAnnotation a) {
        for (XcasAnnotation o : this.positions.keySet()) {
            int aEnd;
            if (!o.type.equals(a.type)) continue;
            int oBegin = o.attributes.containsKey("begin") ? Integer.parseInt(o.getAttribute("begin")) : -1;
            int oEnd = o.attributes.containsKey("end") ? Integer.parseInt(o.getAttribute("end")) : -1;
            int aBegin = a.attributes.containsKey("begin") ? Integer.parseInt(a.getAttribute("begin")) : -2;
            int n = aEnd = a.attributes.containsKey("end") ? Integer.parseInt(a.getAttribute("end")) : -2;
            if (oBegin == aBegin && oEnd == aEnd) {
                return this.positions.get(o);
            }
            if (!o.attributes.containsKey("key") || !a.attributes.containsKey("key") || !o.getAttribute("key").equals(a.getAttribute("key"))) continue;
            return this.positions.get(o);
        }
        return null;
    }

    public boolean hasAnnotation(int id) {
        return this.annotations.containsKey(id);
    }

    public boolean hasAnnotation(XcasAnnotation a) {
        return this.annotations.containsValue(a);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass() || this.annotations.values().size() != ((XcasFile)obj).annotations.values().size()) {
            return false;
        }
        return this.annotations.values().containsAll(((XcasFile)obj).annotations.values());
    }

    public LinkedList<XcasAnnotation> annotationsClone() {
        LinkedList<XcasAnnotation> ret = new LinkedList<XcasAnnotation>();
        Hashtable<XcasAnnotation, XcasAnnotation> cloneMap = new Hashtable<XcasAnnotation, XcasAnnotation>();
        for (XcasAnnotation a : this.annotations.values()) {
            XcasAnnotation c = a.shallowCopy();
            cloneMap.put(a, c);
            ret.add(c);
        }
        for (XcasAnnotation a : this.annotations.values()) {
            for (String s : a.references.keySet()) {
                for (XcasAnnotation r : (Vector)a.references.get(s)) {
                    ((Vector)((XcasAnnotation)cloneMap.get((Object)a)).references.get(s)).add((XcasAnnotation)cloneMap.get(r));
                }
            }
        }
        return ret;
    }

    public Object clone() {
        return null;
    }
}

