/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;

public abstract class BusFactory {
    public static final String BUS_FACTORY_PROPERTY_NAME = "org.apache.cxf.bus.factory";
    public static final String DEFAULT_BUS_FACTORY = "org.apache.cxf.bus.CXFBusFactory";
    protected static Bus defaultBus;
    protected static Map<Thread, Bus> threadBusses;
    private static final Logger LOG;

    public abstract Bus createBus();

    public static synchronized Bus getDefaultBus() {
        return BusFactory.getDefaultBus(true);
    }

    public static synchronized Bus getDefaultBus(boolean createIfNeeded) {
        if (defaultBus == null && createIfNeeded) {
            defaultBus = BusFactory.newInstance().createBus();
        }
        if (defaultBus == null) {
            return null;
        }
        return defaultBus;
    }

    public static synchronized void setDefaultBus(Bus bus) {
        defaultBus = bus == null ? null : bus;
        BusFactory.setThreadDefaultBus(bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setThreadDefaultBus(Bus bus) {
        Thread cur = Thread.currentThread();
        if (bus == null) {
            Map<Thread, Bus> map = threadBusses;
            synchronized (map) {
                threadBusses.remove(cur);
            }
        }
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            threadBusses.put(cur, bus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getAndSetThreadDefaultBus(Bus bus) {
        Thread cur = Thread.currentThread();
        if (bus == null) {
            Map<Thread, Bus> map = threadBusses;
            synchronized (map) {
                return threadBusses.remove(cur);
            }
        }
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            return threadBusses.put(cur, bus);
        }
    }

    public static Bus getThreadDefaultBus() {
        return BusFactory.getThreadDefaultBus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getThreadDefaultBus(boolean createIfNeeded) {
        Bus threadBus;
        Thread cur = Thread.currentThread();
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            threadBus = threadBusses.get(cur);
        }
        if (createIfNeeded && threadBus == null) {
            threadBus = BusFactory.createThreadBus();
        }
        return threadBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Bus createThreadBus() {
        Bus threadBus;
        Thread cur = Thread.currentThread();
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            threadBus = threadBusses.get(cur);
        }
        if (threadBus == null) {
            threadBus = BusFactory.getDefaultBus(true);
            threadBusses.put(cur, threadBus);
        }
        return threadBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDefaultBusForAnyThread(Bus bus) {
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            Iterator<Bus> iterator = threadBusses.values().iterator();
            while (iterator.hasNext()) {
                Bus itBus = iterator.next();
                if (bus != null && itBus != null && !bus.equals(itBus)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean possiblySetDefaultBus(Bus bus) {
        Thread cur = Thread.currentThread();
        Map<Thread, Bus> map = threadBusses;
        synchronized (map) {
            if (threadBusses.get(cur) == null) {
                threadBusses.put(cur, bus);
            }
        }
        if (defaultBus == null) {
            defaultBus = bus;
            return true;
        }
        return false;
    }

    public static BusFactory newInstance() {
        return BusFactory.newInstance(null);
    }

    public static BusFactory newInstance(String className) {
        ClassLoader loader;
        BusFactory instance = null;
        if (className == null && (className = BusFactory.getBusFactoryClass(loader = Thread.currentThread().getContextClassLoader())) == null && loader != BusFactory.class.getClassLoader()) {
            className = BusFactory.getBusFactoryClass(BusFactory.class.getClassLoader());
        }
        if (className == null) {
            className = DEFAULT_BUS_FACTORY;
        }
        try {
            Class<BusFactory> busFactoryClass = ClassLoaderUtils.loadClass((String)className, BusFactory.class).asSubclass(BusFactory.class);
            instance = busFactoryClass.newInstance();
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"BUS_FACTORY_INSTANTIATION_EXC", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return instance;
    }

    protected void initializeBus(Bus bus) {
    }

    private static String getBusFactoryClass(ClassLoader classLoader) {
        String busFactoryClass = null;
        String busFactoryCondition = null;
        busFactoryClass = SystemPropertyAction.getPropertyOrNull((String)BUS_FACTORY_PROPERTY_NAME);
        if (BusFactory.isValidBusFactoryClass(busFactoryClass)) {
            return busFactoryClass;
        }
        try {
            String serviceId = "META-INF/services/org.apache.cxf.bus.factory";
            InputStream is = null;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if ((is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId)) == null) {
                serviceId = "META-INF/cxf/org.apache.cxf.bus.factory";
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            }
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                busFactoryClass = rd.readLine();
                busFactoryCondition = rd.readLine();
                rd.close();
            }
            if (BusFactory.isValidBusFactoryClass(busFactoryClass) && busFactoryCondition != null) {
                try {
                    Class<BusFactory> cls = ClassLoaderUtils.loadClass((String)busFactoryClass, BusFactory.class).asSubclass(BusFactory.class);
                    if (busFactoryCondition.startsWith("#")) {
                        busFactoryCondition = busFactoryCondition.substring(1);
                    }
                    int idx = busFactoryCondition.indexOf(44);
                    while (idx != -1) {
                        cls.getClassLoader().loadClass(busFactoryCondition.substring(0, idx));
                        busFactoryCondition = busFactoryCondition.substring(idx + 1);
                        idx = busFactoryCondition.indexOf(44);
                    }
                    cls.getClassLoader().loadClass(busFactoryCondition);
                }
                catch (ClassNotFoundException e) {
                    busFactoryClass = DEFAULT_BUS_FACTORY;
                }
                catch (NoClassDefFoundError e) {
                    busFactoryClass = DEFAULT_BUS_FACTORY;
                }
            }
            return busFactoryClass;
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"FAILED_TO_DETERMINE_BUS_FACTORY_EXC", (Throwable)ex);
            return busFactoryClass;
        }
    }

    private static boolean isValidBusFactoryClass(String busFactoryClassName) {
        return busFactoryClassName != null && !"".equals(busFactoryClassName);
    }

    static {
        threadBusses = new WeakHashMap<Thread, Bus>();
        LOG = LogUtils.getL7dLogger(BusFactory.class, (String)"APIMessages");
    }
}

