/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.cxf.resource.URIResolver;
import org.xml.sax.InputSource;

public class ExtendedURIResolver {
    protected URIResolver currentResolver;
    protected String lastestImportUri;
    protected Stack<InputStream> resourceOpened = new Stack();

    public ExtendedURIResolver() {
        this.currentResolver = new URIResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputSource resolve(String curUri, String baseUri) {
        try {
            try {
                this.currentResolver.resolve(baseUri, curUri, this.getClass());
                if (!this.currentResolver.isResolved()) {
                    Object var7_8 = null;
                    this.lastestImportUri = curUri;
                    return null;
                }
                if (this.currentResolver.getURI() != null && this.currentResolver.getURI().isAbsolute()) {
                    curUri = this.currentResolver.getURI().toString();
                }
                if (this.currentResolver.isFile()) {
                    curUri = this.currentResolver.getFile().getAbsoluteFile().toURI().toString();
                }
                InputStream in = this.currentResolver.getInputStream();
                this.resourceOpened.addElement(in);
                InputSource source = new InputSource(in);
                source.setSystemId(curUri);
                source.setPublicId(curUri);
                InputSource inputSource = source;
                Object var7_7 = null;
                this.lastestImportUri = curUri;
                return inputSource;
            }
            catch (IOException iOException) {
                Object var7_9 = null;
                this.lastestImportUri = curUri;
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.lastestImportUri = curUri;
            throw throwable;
        }
    }

    public void close() {
        while (!this.resourceOpened.isEmpty()) {
            try {
                InputStream in = this.resourceOpened.pop();
                if (in == null) continue;
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getLatestImportURI() {
        return this.getURI();
    }

    public String getURI() {
        if (this.currentResolver.getURI() != null) {
            return this.currentResolver.getURI().toString();
        }
        return this.lastestImportUri;
    }
}

