/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public final class UrlUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(UrlUtils.class);
    private static final String[] RESERVED_CHARS = new String[]{"+"};
    private static final String[] ENCODED_CHARS = new String[]{"%2b"};

    private UrlUtils() {
    }

    public static String urlDecode(String value, String enc) {
        try {
            value = URLDecoder.decode(value, enc);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning("UTF-8 encoding can not be used to decode " + value);
        }
        return value;
    }

    public static String urlDecode(String value) {
        return UrlUtils.urlDecode(value, "UTF-8");
    }

    public static String pathDecode(String value) {
        for (int i = 0; i < RESERVED_CHARS.length; ++i) {
            if (value.indexOf(RESERVED_CHARS[i]) == -1) continue;
            value = value.replace(RESERVED_CHARS[i], ENCODED_CHARS[i]);
        }
        return UrlUtils.urlDecode(value);
    }

    public static Map<String, String> parseQueryString(String s) {
        HashMap<String, String> ht = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                ht.put(pair.toLowerCase(), "");
                continue;
            }
            ht.put(pair.substring(0, pos).toLowerCase(), pair.substring(pos + 1));
        }
        return ht;
    }

    public static String getStem(String baseURI) {
        URI uri = URI.create(baseURI);
        int idx = (baseURI = uri.getRawPath()).lastIndexOf(47);
        if (idx != -1) {
            baseURI = baseURI.substring(0, idx);
        }
        return URI.create(baseURI).getPath();
    }
}

