/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class LoggingOutInterceptor
extends AbstractPhaseInterceptor {
    private static final String LOG_SETUP = LoggingOutInterceptor.class.getName() + ".log-setup";
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingOutInterceptor.class);
    private int limit = 102400;
    private PrintWriter writer;
    private boolean prettyLogging;

    public LoggingOutInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public LoggingOutInterceptor() {
        this("pre-stream");
    }

    public LoggingOutInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LoggingOutInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public void setPrettyLogging(boolean flag) {
        this.prettyLogging = flag;
    }

    public boolean isPrettyLogging() {
        return this.prettyLogging;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        boolean hasLogged;
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        if ((LOG.isLoggable(Level.INFO) || this.writer != null) && !(hasLogged = message.containsKey(LOG_SETUP))) {
            message.put(LOG_SETUP, Boolean.TRUE);
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            message.setContent(OutputStream.class, newOut);
            newOut.registerCallback(new LoggingCallback(message, os));
        }
    }

    protected String transform(String originalLogString) {
        return originalLogString;
    }

    protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (this.isPrettyLogging() && contentType != null && contentType.indexOf("xml") >= 0) {
            Transformer serializer = XMLUtils.newTransformer(2);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            String result = swriter.toString();
            if (result.length() < this.limit || this.limit == -1) {
                builder.append(swriter.toString());
            } else {
                builder.append(swriter.toString().substring(0, this.limit));
            }
        } else if (StringUtils.isEmpty(encoding)) {
            cos.writeCacheTo(builder, this.limit);
        } else {
            cos.writeCacheTo(builder, encoding, this.limit);
        }
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;

        public LoggingCallback(Message msg, OutputStream os) {
            this.message = msg;
            this.origStream = os;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            Object headers;
            String ct;
            String address;
            String encoding;
            String id = (String)this.message.getExchange().get(LoggingMessage.ID_KEY);
            if (id == null) {
                id = LoggingMessage.nextId();
                this.message.getExchange().put(LoggingMessage.ID_KEY, id);
            }
            LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
            Integer responseCode = (Integer)this.message.get(Message.RESPONSE_CODE);
            if (responseCode != null) {
                buffer.getResponseCode().append(responseCode);
            }
            if ((encoding = (String)this.message.get(Message.ENCODING)) != null) {
                buffer.getEncoding().append(encoding);
            }
            if ((address = (String)this.message.get(Message.ENDPOINT_ADDRESS)) != null) {
                buffer.getAddress().append(address);
            }
            if ((ct = (String)this.message.get("Content-Type")) != null) {
                buffer.getContentType().append(ct);
            }
            if ((headers = this.message.get(Message.PROTOCOL_HEADERS)) != null) {
                buffer.getHeader().append(headers);
            }
            if (cos.getTempFile() == null) {
                if (cos.size() > LoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LoggingOutInterceptor.this.limit + " bytes)\n");
                }
            } else {
                buffer.getMessage().append("Outbound Message (saved to tmp file):\n");
                buffer.getMessage().append("Filename: " + cos.getTempFile().getAbsolutePath() + "\n");
                if (cos.size() > LoggingOutInterceptor.this.limit) {
                    buffer.getMessage().append("(message truncated to " + LoggingOutInterceptor.this.limit + " bytes)\n");
                }
            }
            try {
                LoggingOutInterceptor.this.writePayload(buffer.getPayload(), cos, encoding, ct);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (LoggingOutInterceptor.this.writer != null) {
                LoggingOutInterceptor.this.writer.println(LoggingOutInterceptor.this.transform(buffer.toString()));
            } else if (LOG.isLoggable(Level.INFO)) {
                LOG.info(LoggingOutInterceptor.this.transform(buffer.toString()));
            }
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, this.origStream);
        }
    }
}

