/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension {
    private static final Logger LOG = LogUtils.getL7dLogger(Extension.class);
    protected String className;
    protected ClassLoader classloader;
    protected Class<?> clazz;
    protected Class<?> intf;
    protected String interfaceName;
    protected boolean deferred;
    protected Collection<String> namespaces = new ArrayList<String>();
    protected Object[] args;
    protected Object obj;

    public Extension() {
    }

    public Extension(Class<?> cls, Class<?> inf) {
        this.clazz = cls;
        this.intf = inf;
        this.interfaceName = inf.getName();
        this.className = cls.getName();
        this.classloader = cls.getClassLoader();
    }

    public Extension(Class<?> cls) {
        this.clazz = cls;
        this.className = cls.getName();
        this.classloader = cls.getClassLoader();
    }

    public Extension(Extension ext) {
        this.className = ext.className;
        this.interfaceName = ext.interfaceName;
        this.deferred = ext.deferred;
        this.namespaces = ext.namespaces;
        this.obj = ext.obj;
        this.clazz = ext.clazz;
        this.intf = ext.intf;
        this.classloader = ext.classloader;
        this.args = ext.args;
    }

    public String getName() {
        return StringUtils.isEmpty(this.interfaceName) ? this.className : this.interfaceName;
    }

    public Object getLoadedObject() {
        return this.obj;
    }

    public Extension cloneNoObject() {
        Extension ext = new Extension(this);
        ext.obj = null;
        ext.clazz = null;
        ext.intf = null;
        return ext;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("class: ");
        buf.append(this.className);
        buf.append(", interface: ");
        buf.append(this.interfaceName);
        buf.append(", deferred: ");
        buf.append(this.deferred ? "true" : "false");
        buf.append(", namespaces: (");
        int n = 0;
        for (String ns : this.namespaces) {
            if (n > 0) {
                buf.append(", ");
            }
            buf.append(ns);
            ++n;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getClassname() {
        return this.className;
    }

    public void setClassname(String i) {
        this.clazz = null;
        this.className = i;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String i) {
        this.interfaceName = i;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public void setDeferred(boolean d) {
        this.deferred = d;
    }

    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    public void setArgs(Object[] a) {
        this.args = a;
    }

    public Class<?> getClassObject(ClassLoader cl) {
        if (this.clazz == null) {
            if (this.classloader != null) {
                try {
                    this.clazz = this.classloader.loadClass(this.className);
                    return this.clazz;
                }
                catch (ClassNotFoundException nex) {
                    // empty catch block
                }
            }
            try {
                this.clazz = cl.loadClass(this.className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    this.clazz = this.getClass().getClassLoader().loadClass(this.className);
                }
                catch (ClassNotFoundException nex) {
                    throw new ExtensionException(new Message("PROBLEM_LOADING_EXTENSION_CLASS", LOG, this.className), (Throwable)nex);
                }
            }
        }
        return this.clazz;
    }

    public Object load(ClassLoader cl, Bus b) {
        Class<?> cls = this.getClassObject(cl);
        try {
            try {
                if (b != null && this.args == null) {
                    Constructor<?> con = cls.getConstructor(Bus.class);
                    this.obj = con.newInstance(b);
                    return this.obj;
                }
                if (b != null && this.args != null) {
                    Constructor<?> con;
                    boolean noBus = false;
                    try {
                        con = cls.getConstructor(Bus.class, Object[].class);
                    }
                    catch (Exception ex) {
                        con = cls.getConstructor(Object[].class);
                        noBus = true;
                    }
                    this.obj = noBus ? con.newInstance(this.args) : con.newInstance(b, this.args);
                    return this.obj;
                }
                if (this.args != null) {
                    Constructor<?> con = cls.getConstructor(Object[].class);
                    this.obj = con.newInstance(this.args);
                    return this.obj;
                }
            }
            catch (InvocationTargetException ex) {
                throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), ex.getCause());
            }
            catch (InstantiationException ex) {
                throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)ex);
            }
            catch (SecurityException ex) {
                throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)ex);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            this.obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ExtensionException ex) {
            throw ex;
        }
        catch (IllegalAccessException ex) {
            throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)ex);
        }
        catch (IllegalArgumentException e) {
            throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), (Throwable)e);
        }
        catch (InvocationTargetException ex) {
            throw new ExtensionException(new Message("PROBLEM_CREATING_EXTENSION_CLASS", LOG, cls.getName()), ex.getCause());
        }
        catch (NoSuchMethodException ex) {
            ArrayList<Object> a = new ArrayList<Object>();
            if (b != null) {
                a.add(b);
            }
            if (this.args != null) {
                a.add(this.args);
            }
            throw new ExtensionException(new Message("PROBLEM_FINDING_CONSTRUCTOR", LOG, cls.getName(), a), (Throwable)ex);
        }
        return this.obj;
    }

    public Class loadInterface(ClassLoader cl) {
        if (this.intf != null) {
            return this.intf;
        }
        if (this.classloader != null) {
            try {
                this.intf = this.classloader.loadClass(this.interfaceName);
                if (this.intf != null) {
                    return this.intf;
                }
            }
            catch (ClassNotFoundException nex) {
                // empty catch block
            }
        }
        try {
            this.intf = cl.loadClass(this.interfaceName);
        }
        catch (ClassNotFoundException ex) {
            try {
                this.intf = this.getClass().getClassLoader().loadClass(this.interfaceName);
            }
            catch (ClassNotFoundException nex) {
                throw new ExtensionException(nex);
            }
        }
        return this.intf;
    }
}

