/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.HttpServletRequestSnapshot;
import org.apache.cxf.transport.http.Servlet3ContinuationProvider;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl.WSDLLibrary;

public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String HTTP_CONFIG = "HTTP.CONFIG";
    public static final String HTTP_CONTEXT_MATCH_STRATEGY = "HTTP_CONTEXT_MATCH_STRATEGY";
    public static final String RESPONSE_HEADERS_COPIED = "http.headers.copied";
    public static final String RESPONSE_COMMITED = "http.response.done";
    public static final String REQUEST_REDIRECTED = "http.request.redirected";
    public static final String CXF_CONTINUATION_MESSAGE = "cxf.continuation.message";
    public static final String CXF_ASYNC_CONTEXT = "cxf.async.context";
    public static final String SERVICE_REDIRECTION = "http.service.redirection";
    private static final String HTTP_BASE_PATH = "http.base.path";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    protected final Bus bus;
    protected DestinationRegistry registry;
    protected final String path;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy = "stem";
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;
    protected CertConstraints certConstraints;
    protected boolean isServlet3;

    public AbstractHTTPDestination(Bus b, DestinationRegistry registry, EndpointInfo ei, String path, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference(AbstractHTTPDestination.getAddressValue(ei, dp), b), ei);
        this.bus = b;
        this.registry = registry;
        this.path = path;
        try {
            ServletRequest.class.getMethod("isAsyncSupported", new Class[0]);
            this.isServlet3 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.initConfig();
    }

    public Bus getBus() {
        return this.bus;
    }

    private AuthorizationPolicy getAuthorizationPolicyFromMessage(String credentials) {
        if (credentials == null || StringUtils.isEmpty(credentials.trim())) {
            return null;
        }
        String authType = credentials.split(" ")[0];
        if ("Basic".equals(authType)) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode(authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo.length > 0 ? authInfo[0] : "";
                String password = authInfo.length > 1 ? authInfo[1] : "";
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                return policy;
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    protected final boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex == null ? false : ex.isOneWay();
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block4: {
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                LOG.fine("Create a new message for processing");
                inMessage = new MessageImpl();
                this.setupMessage(inMessage, config, context, req, resp);
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                exchange.setSession(new HTTPSession(req));
                ((MessageImpl)inMessage).setDestination(this);
            } else {
                LOG.fine("Get the message from the request for processing");
            }
            this.copyKnownRequestParameters(req, inMessage);
            try {
                this.incomingObserver.onMessage(inMessage);
            }
            catch (SuspendedInvocationException ex) {
                if (ex.getRuntimeException() == null) break block4;
                throw ex.getRuntimeException();
            }
        }
    }

    private void copyKnownRequestParameters(HttpServletRequest request, Message message) {
        message.put(SERVICE_REDIRECTION, request.getParameter(SERVICE_REDIRECTION));
    }

    protected void setupMessage(Message inMessage, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupMessage(inMessage, null, context, req, resp);
    }

    protected void setupMessage(final Message inMessage, ServletConfig config, ServletContext context, final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int index;
        String servletPath;
        this.setupContinuation(inMessage, req, resp);
        DelegatingInputStream in = new DelegatingInputStream((InputStream)req.getInputStream()){

            public void cacheInput() {
                if (!this.cached && inMessage.getExchange().getOutMessage() == null) {
                    inMessage.put(AbstractHTTPDestination.HTTP_REQUEST, new HttpServletRequestSnapshot(req));
                }
                super.cacheInput();
            }
        };
        inMessage.setContent(DelegatingInputStream.class, in);
        inMessage.setContent(InputStream.class, in);
        inMessage.put(HTTP_REQUEST, req);
        inMessage.put(HTTP_RESPONSE, resp);
        inMessage.put(HTTP_CONTEXT, context);
        inMessage.put(HTTP_CONFIG, config);
        inMessage.put(HTTP_CONTEXT_MATCH_STRATEGY, this.contextMatchStrategy);
        inMessage.put("org.apache.cxf.request.method", req.getMethod());
        String requestURI = req.getRequestURI();
        inMessage.put("org.apache.cxf.request.uri", requestURI);
        String requestURL = req.getRequestURL().toString();
        inMessage.put("org.apache.cxf.request.url", requestURL);
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        if ((servletPath = req.getServletPath()) == null) {
            servletPath = "";
        }
        String contextServletPath = contextPath + servletPath;
        inMessage.put(Message.PATH_INFO, contextServletPath + req.getPathInfo());
        if (!StringUtils.isEmpty(requestURI)) {
            index = requestURL.indexOf(requestURI);
            if (index > 0) {
                String schemaInfo = requestURL.substring(0, index);
                String basePathWithContextOnly = schemaInfo + contextPath;
                inMessage.put(HTTP_BASE_PATH, basePathWithContextOnly);
            }
        } else if (!StringUtils.isEmpty(servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            inMessage.put(HTTP_BASE_PATH, requestURL.substring(0, index));
        }
        String contentType = req.getContentType();
        inMessage.put("Content-Type", contentType);
        this.setEncoding(inMessage, req, contentType);
        inMessage.put(Message.QUERY_STRING, req.getQueryString());
        inMessage.put("Accept", req.getHeader("Accept"));
        String basePath = this.getBasePath(contextServletPath);
        if (!StringUtils.isEmpty(basePath)) {
            inMessage.put(Message.BASE_PATH, basePath);
        }
        inMessage.put(Message.FIXED_PARAMETER_ORDER, this.isFixedParameterOrder());
        inMessage.put("org.apache.cxf.async.post.response.dispatch", Boolean.TRUE);
        inMessage.put(SecurityContext.class, new SecurityContext(){
            private Principal pp;
            {
                this.pp = req.getUserPrincipal();
            }

            public Principal getUserPrincipal() {
                return this.pp;
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }
        });
        Headers headers = new Headers(inMessage);
        headers.copyFromRequest(req);
        String credentials = headers.getAuthorization();
        AuthorizationPolicy authPolicy = this.getAuthorizationPolicyFromMessage(credentials);
        inMessage.put(AuthorizationPolicy.class, authPolicy);
        SSLUtils.propogateSecureSession(req, inMessage);
        inMessage.put(CertConstraints.class.getName(), this.certConstraints);
        inMessage.put(Message.IN_INTERCEPTORS, Arrays.asList(CertConstraintsInterceptor.INSTANCE));
    }

    private String setEncoding(Message inMessage, HttpServletRequest req, String contentType) throws IOException {
        String enc = HttpHeaderHelper.findCharset(contentType);
        if (enc == null) {
            enc = req.getCharacterEncoding();
        }
        if (enc != null && enc.endsWith("\"")) {
            enc = enc.substring(0, enc.length() - 1);
        }
        if (enc != null || "POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) {
            String normalizedEncoding = HttpHeaderHelper.mapCharset(enc);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, enc).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put(Message.ENCODING, normalizedEncoding);
        }
        return contentType;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        if (!this.isServlet3) {
            return null;
        }
        return this.retrieveFromServlet3Async(req);
    }

    protected Message retrieveFromServlet3Async(HttpServletRequest req) {
        try {
            return (Message)req.getAttribute(CXF_CONTINUATION_MESSAGE);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        try {
            if (this.isServlet3 && req.isAsyncSupported()) {
                inMessage.put(ContinuationProvider.class.getName(), new Servlet3ContinuationProvider(req, resp, inMessage));
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty(this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.endpointInfo.getAddress()).getPath();
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        return AbstractHTTPDestination.getAddressValue(ei, true);
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        if (dp) {
            String addr;
            String eiAddress = ei.getAddress();
            if (eiAddress == null) {
                try {
                    ServerSocket s = new ServerSocket(0);
                    ei.setAddress("http://localhost:" + s.getLocalPort());
                    s.close();
                    return ei;
                }
                catch (IOException ex) {
                    ei.setAddress("http://localhost");
                }
            }
            if ((addr = StringUtils.addDefaultPortIfMissing(ei.getAddress())) != null) {
                ei.setAddress(addr);
            }
        }
        return ei;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        HttpServletResponse response = (HttpServletResponse)inMessage.get(HTTP_RESPONSE);
        return new BackChannelConduit(response);
    }

    private void initConfig() {
        PolicyEngine engine = this.bus.getExtension(PolicyEngine.class);
        if (null != engine && engine.isEnabled() && null != this.endpointInfo.getService()) {
            this.server = PolicyUtils.getServer(engine, this.endpointInfo, this);
        }
        if (null == this.server && WSDLLibrary.isAvailable()) {
            this.server = this.endpointInfo.getTraversedExtensor(new HTTPServerPolicy(), HTTPServerPolicy.class);
        }
    }

    private void cacheInput(Message outMessage) {
        DelegatingInputStream in;
        if (outMessage.getExchange() == null) {
            return;
        }
        Message inMessage = outMessage.getExchange().getInMessage();
        if (inMessage == null) {
            return;
        }
        Collection<Attachment> atts = inMessage.getAttachments();
        if (atts != null) {
            for (Attachment a : atts) {
                if (!(a.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                try {
                    ((AttachmentDataSource)a.getDataHandler().getDataSource()).cache(inMessage);
                }
                catch (IOException e) {
                    throw new Fault(e);
                }
            }
        }
        if ((in = inMessage.getContent(DelegatingInputStream.class)) != null) {
            in.cacheInput();
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        return this.flushHeaders(outMessage, true);
    }

    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        if (this.isResponseRedirected(outMessage)) {
            return null;
        }
        this.cacheInput(outMessage);
        if (this.server != null) {
            new Headers(outMessage).setFromServerPolicy(this.server);
        }
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        HttpServletResponse response = this.getHttpResponseFromMessage(outMessage);
        int responseCode = this.getReponseCodeFromMessage(outMessage);
        response.setStatus(responseCode);
        if (500 == responseCode) {
            new Headers(outMessage).removeContentType();
        }
        new Headers(outMessage).copyToResponse(response);
        outMessage.put(RESPONSE_HEADERS_COPIED, "true");
        if (this.hasNoResponseContent(outMessage)) {
            response.setContentLength(0);
            response.flushBuffer();
            response.getOutputStream().close();
        } else if (!getStream) {
            response.getOutputStream().close();
        } else {
            responseStream = response.getOutputStream();
        }
        if (oneWay) {
            outMessage.remove(HTTP_RESPONSE);
        }
        return responseStream;
    }

    private int getReponseCodeFromMessage(Message message) {
        Integer i = (Integer)message.get(Message.RESPONSE_CODE);
        if (i != null) {
            return i;
        }
        if (this.hasNoResponseContent(message)) {
            return 202;
        }
        return 200;
    }

    private boolean hasNoResponseContent(Message message) {
        boolean ow = this.isOneWay(message);
        boolean pr = MessageUtils.isPartialResponse(message);
        boolean epr = MessageUtils.isEmptyPartialResponse(message);
        return ow && (!pr || epr) || !ow && epr;
    }

    private HttpServletResponse getHttpResponseFromMessage(Message message) throws IOException {
        Object responseObj = message.get(HTTP_RESPONSE);
        if (responseObj instanceof HttpServletResponse) {
            return (HttpServletResponse)responseObj;
        }
        if (null != responseObj) {
            String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, responseObj.getClass()).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
        LOG.log(Level.WARNING, m);
        throw new IOException(m);
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get(REQUEST_REDIRECTED));
    }

    protected boolean contextMatchOnExact() {
        return "exact".equals(this.contextMatchStrategy);
    }

    public void finalizeConfig() {
    }

    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress(this.reference);
            ref = EndpointReferenceUtils.duplicate(this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress(ref, address + id);
            } else {
                EndpointReferenceUtils.setAddress(ref, address + "/" + id);
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        return ref;
    }

    public String getId(Map context) {
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            return super.getId(context);
        }
        return id;
    }

    public String getContextMatchStrategy() {
        return this.contextMatchStrategy;
    }

    public void setContextMatchStrategy(String contextMatchStrategy) {
        this.contextMatchStrategy = contextMatchStrategy;
    }

    public boolean isFixedParameterOrder() {
        return this.fixedParameterOrder;
    }

    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        this.fixedParameterOrder = fixedParameterOrder;
    }

    public boolean isMultiplexWithAddress() {
        return this.multiplexWithAddress;
    }

    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        this.multiplexWithAddress = multiplexWithAddress;
    }

    public HTTPServerPolicy getServer() {
        return this.server;
    }

    public void setServer(HTTPServerPolicy server) {
        this.server = server;
    }

    public void assertMessage(Message message) {
        PolicyUtils.assertServerPolicy(message, this.server);
    }

    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPSERVERPOLICY_ASSERTION_QNAME.equals(type);
    }

    public void releaseRegistry() {
        this.registry = null;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.addDestination(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
        super.shutdown();
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (!this.written && this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage, false))) {
                this.wrappedStream = responseStream;
            }
            if (this.wrappedStream != null) {
                this.wrappedStream.close();
                this.response.flushBuffer();
            }
        }

        public void flush() throws IOException {
        }
    }

    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;

        BackChannelConduit(HttpServletResponse resp) {
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put(AbstractHTTPDestination.HTTP_RESPONSE, this.response);
            OutputStream os = message.getContent(OutputStream.class);
            if (os == null) {
                message.setContent(OutputStream.class, new WrappedOutputStream(message, this.response));
            }
        }

        public void close(Message msg) throws IOException {
            super.close(msg);
            if (msg.getExchange() == null) {
                return;
            }
            Message m = msg.getExchange().getInMessage();
            if (m == null) {
                return;
            }
            InputStream is = m.getContent(InputStream.class);
            if (is != null) {
                try {
                    is.close();
                    m.removeContent(InputStream.class);
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
        }
    }
}

