/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.extension.TextExtensionFragmentParser;
import org.apache.cxf.bus.osgi.CXFActivator;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFExtensionBundleListener
implements SynchronousBundleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFActivator.class);
    private long id;
    private ConcurrentMap<Long, List<Extension>> extensions = new ConcurrentHashMap<Long, List<Extension>>();

    public CXFExtensionBundleListener(long bundleId) {
        this.id = bundleId;
    }

    public void registerExistingBundles(BundleContext context) throws IOException {
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId()) continue;
            this.register(bundle);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    protected void register(Bundle bundle) {
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        while (e != null && e.hasMoreElements()) {
            List<Extension> orig = new TextExtensionFragmentParser().getExtensions((URL)e.nextElement());
            this.addExtensions(bundle, orig);
        }
    }

    private void addExtensions(Bundle bundle, List<Extension> orig) {
        if (orig.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(orig.size());
        for (Extension ext : orig) {
            names.add(ext.getName());
        }
        LOG.info("Adding the extensions from bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ") " + names);
        CopyOnWriteArrayList<Extension> list = (CopyOnWriteArrayList<Extension>)this.extensions.get(bundle.getBundleId());
        if (list == null) {
            list = new CopyOnWriteArrayList<Extension>();
            this.extensions.put(bundle.getBundleId(), list);
        }
        for (Extension ext : orig) {
            list.add(new OSGiExtension(ext, bundle));
        }
        ExtensionRegistry.addExtensions(list);
    }

    protected void unregister(long bundleId) {
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            LOG.info("Removing the extensions for bundle " + bundleId);
            ExtensionRegistry.removeExtensions(list);
        }
    }

    public void shutdown() {
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        @Override
        public Class<?> getClassObject(ClassLoader cl) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.bundle.loadClass(this.className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return super.getClassObject(cl);
        }

        @Override
        public Class<?> loadInterface(ClassLoader cl) {
            try {
                return this.bundle.loadClass(this.interfaceName);
            }
            catch (Throwable throwable) {
                return super.loadInterface(cl);
            }
        }

        @Override
        public Extension cloneNoObject() {
            OSGiExtension ext = new OSGiExtension(this, this.bundle);
            ext.obj = null;
            return ext;
        }
    }
}

