/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ParameterizedCollectionType;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
extends AbstractClient {
    private static final String REQUEST_CLASS = "request.class";
    private static final String REQUEST_TYPE = "request.type";
    private static final String RESPONSE_CLASS = "response.class";
    private static final String RESPONSE_TYPE = "response.type";

    protected WebClient(String baseAddress) {
        this(WebClient.convertStringToURI(baseAddress));
    }

    protected WebClient(URI baseAddress) {
        super(baseAddress);
    }

    protected WebClient(ClientState state) {
        super(state);
    }

    public static WebClient create(String baseAddress) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        return bean.createWebClient();
    }

    public static WebClient create(URI baseURI) {
        return WebClient.create(baseURI.toString());
    }

    public static WebClient create(String baseURI, boolean threadSafe) {
        return WebClient.create(baseURI, Collections.emptyList(), threadSafe);
    }

    public static WebClient create(String baseAddress, List<?> providers) {
        return WebClient.create(baseAddress, providers, null);
    }

    public static WebClient create(String baseAddress, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, List<AbstractFeature> features, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setFeatures(features);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient fromClient(Client client) {
        return WebClient.fromClient(client, false);
    }

    public static WebClient fromClient(Client client, boolean inheritHeaders) {
        WebClient webClient = null;
        ClientState clientState = WebClient.getClientState(client);
        if (clientState == null) {
            webClient = WebClient.create(client.getCurrentURI());
            if (inheritHeaders) {
                webClient.headers((MultivaluedMap)client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            webClient = new WebClient(clientState.newState(client.getCurrentURI(), headers, null));
        }
        WebClient.copyProperties(webClient, client);
        return webClient;
    }

    public static Client client(Object proxy) {
        if (proxy instanceof Client) {
            return (Client)proxy;
        }
        return null;
    }

    public static ClientConfiguration getConfig(Object client) {
        if (client instanceof Client) {
            if (client instanceof WebClient) {
                return ((AbstractClient)client).getConfiguration();
            }
            if (client instanceof InvocationHandlerAware) {
                Object handler = ((InvocationHandlerAware)client).getInvocationHandler();
                return ((AbstractClient)handler).getConfiguration();
            }
        }
        throw new IllegalArgumentException("Not a valid Client");
    }

    public Response invoke(String httpMethod, Object body) {
        return this.doInvoke(httpMethod, body, null, Response.class, (Type)((Object)Response.class));
    }

    public Response post(Object body) {
        return this.invoke("POST", body);
    }

    public Response put(Object body) {
        return this.invoke("PUT", body);
    }

    public Response get() {
        return this.invoke("GET", null);
    }

    public Response head() {
        return this.invoke("HEAD", null);
    }

    public Response options() {
        return this.invoke("OPTIONS", null);
    }

    public Response delete() {
        return this.invoke("DELETE", null);
    }

    public Response form(Map<String, List<Object>> values) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", values, null, Response.class, (Type)((Object)Response.class));
    }

    public Response form(Form form) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", form.getData(), null, Response.class, (Type)((Object)Response.class));
    }

    public <T> T invoke(String httpMethod, Object body, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, null, responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T invoke(String httpMethod, Object body, Class<?> requestClass, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, requestClass, null, responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T post(Object body, Class<T> responseClass) {
        return this.invoke("POST", body, responseClass);
    }

    public <T> T put(Object body, Class<T> responseClass) {
        return this.invoke("PUT", body, responseClass);
    }

    public <T> Collection<? extends T> invokeAndGetCollection(String httpMethod, Object body, Class<T> memberClass) {
        Response r = this.doInvoke(httpMethod, body, null, Collection.class, new ParameterizedCollectionType(memberClass));
        return CastUtils.cast((Collection)r.getEntity(), memberClass);
    }

    public <T> Response postCollection(Object collection, Class<T> memberClass) {
        return this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Response.class, (Type)((Object)Response.class));
    }

    public <T1, T2> T2 postCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T1, T2> Collection<? extends T2> postAndGetCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postObjectGetCollection(Object body, Class<T> responseClass) {
        Response r = this.doInvoke("POST", body, null, Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postAndGetCollection(Object body, Class<T> memberClass) {
        return this.invokeAndGetCollection("POST", body, memberClass);
    }

    public <T> Collection<? extends T> getCollection(Class<T> memberClass) {
        return this.invokeAndGetCollection("GET", null, memberClass);
    }

    public <T> T get(Class<T> responseClass) {
        return this.invoke("GET", null, responseClass);
    }

    public WebClient path(Object path) {
        this.getCurrentBuilder().path(path.toString());
        return this;
    }

    public WebClient path(String path, Object ... values) {
        URI u = UriBuilder.fromUri((URI)URI.create("http://tempuri")).path(path).buildFromEncoded(values);
        this.getState().setTemplates(this.getTemplateParametersMap(new URITemplate(path), Arrays.asList(values)));
        return this.path(u.getRawPath());
    }

    public WebClient query(String name, Object ... values) {
        if (!"".equals(name)) {
            this.getCurrentBuilder().queryParam(name, values);
        } else {
            WebClient.addParametersToBuilder(this.getCurrentBuilder(), name, values[0], ParameterType.QUERY);
        }
        return this;
    }

    public WebClient matrix(String name, Object ... values) {
        if (!"".equals(name)) {
            this.getCurrentBuilder().matrixParam(name, values);
        } else {
            WebClient.addParametersToBuilder(this.getCurrentBuilder(), name, values[0], ParameterType.MATRIX);
        }
        return this;
    }

    public WebClient fragment(String name) {
        this.getCurrentBuilder().fragment(name);
        return this;
    }

    public WebClient to(String newAddress, boolean forward) {
        this.getState().setTemplates(null);
        if (forward) {
            if (!newAddress.startsWith(this.getBaseURI().toString())) {
                throw new IllegalArgumentException("Base address can not be preserved");
            }
            this.resetCurrentBuilder(URI.create(newAddress));
        } else {
            this.resetBaseAddress(URI.create(newAddress));
        }
        return this;
    }

    public WebClient back(boolean fast) {
        this.getState().setTemplates(null);
        if (fast) {
            this.getCurrentBuilder().replacePath(this.getBaseURI().getPath());
        } else {
            URI uri = this.getCurrentURI();
            if (uri == this.getBaseURI()) {
                return this;
            }
            List<PathSegment> segments = JAXRSUtils.getPathSegments(uri.getPath(), false);
            this.getCurrentBuilder().replacePath(null);
            for (int i = 0; i < segments.size() - 1; ++i) {
                this.getCurrentBuilder().path(HttpUtils.fromPathSegment(segments.get(i)));
            }
        }
        return this;
    }

    public WebClient replacePath(String path) {
        if (path == null) {
            return this.back(true);
        }
        this.back(path.startsWith("/"));
        return this.path(path);
    }

    public WebClient resetQuery() {
        return this.replaceQuery(null);
    }

    public WebClient replaceQuery(String queryString) {
        this.getCurrentBuilder().replaceQuery(queryString);
        return this;
    }

    public WebClient replaceHeader(String headerName, String value) {
        MultivaluedMap<String, String> headers = this.getState().getRequestHeaders();
        headers.remove((Object)headerName);
        if (value != null) {
            headers.add((Object)headerName, (Object)value);
        }
        return this;
    }

    public WebClient replaceQueryParam(String queryParam, Object ... value) {
        this.getCurrentBuilder().replaceQueryParam(queryParam, value);
        return this;
    }

    @Override
    public WebClient type(MediaType ct) {
        return (WebClient)super.type(ct);
    }

    @Override
    public WebClient type(String type) {
        return (WebClient)super.type(type);
    }

    @Override
    public WebClient accept(MediaType ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient accept(String ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient language(String language) {
        return (WebClient)super.language(language);
    }

    @Override
    public WebClient acceptLanguage(String ... languages) {
        return (WebClient)super.acceptLanguage(languages);
    }

    @Override
    public WebClient encoding(String encoding) {
        return (WebClient)super.encoding(encoding);
    }

    @Override
    public WebClient acceptEncoding(String ... encodings) {
        return (WebClient)super.acceptEncoding(encodings);
    }

    @Override
    public WebClient match(EntityTag tag, boolean ifNot) {
        return (WebClient)super.match(tag, ifNot);
    }

    @Override
    public WebClient modified(Date date, boolean ifNot) {
        return (WebClient)super.modified(date, ifNot);
    }

    @Override
    public WebClient cookie(Cookie cookie) {
        return (WebClient)super.cookie(cookie);
    }

    @Override
    public WebClient header(String name, Object ... values) {
        return (WebClient)super.header(name, values);
    }

    @Override
    public WebClient headers(MultivaluedMap<String, String> map) {
        return (WebClient)super.headers(map);
    }

    @Override
    public WebClient reset() {
        return (WebClient)super.reset();
    }

    protected Response doInvoke(String httpMethod, Object body, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        return this.doInvoke(httpMethod, body, body == null ? null : body.getClass(), inGenericType, responseClass, outGenericType);
    }

    private static Type getGenericEntityType(GenericEntity<?> genericEntity, Type inGenericType) {
        if (inGenericType != null && genericEntity.getType() != inGenericType) {
            throw new IllegalArgumentException("Illegal type");
        }
        return genericEntity.getType();
    }

    protected Response doInvoke(String httpMethod, Object body, Class<?> requestClass, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        MultivaluedMap<String, String> headers;
        boolean contentTypeNotSet;
        if (body instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)body;
            body = genericEntity.getEntity();
            requestClass = genericEntity.getRawType();
            inGenericType = WebClient.getGenericEntityType(genericEntity, inGenericType);
        }
        boolean bl = contentTypeNotSet = (headers = this.getHeaders()).getFirst((Object)"Content-Type") == null;
        if (contentTypeNotSet) {
            String ct = "*/*";
            if (body != null) {
                ct = body instanceof Form ? "application/x-www-form-urlencoded" : "application/xml";
            }
            headers.putSingle((Object)"Content-Type", (Object)ct);
        }
        if (responseClass != null && responseClass != Response.class && headers.getFirst((Object)"Accept") == null) {
            headers.putSingle((Object)"Accept", (Object)JAXRSUtils.mediaTypeToString(MediaType.APPLICATION_XML_TYPE));
        }
        this.resetResponse();
        Response r = this.doChainedInvocation(httpMethod, headers, body, requestClass, inGenericType, responseClass, outGenericType, null, null);
        if (r.getStatus() >= 400 && responseClass != Response.class) {
            throw new ServerWebApplicationException(r);
        }
        return r;
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        String httpMethod = (String)reqContext.get("org.apache.cxf.request.method");
        Class requestClass = (Class)reqContext.get(REQUEST_CLASS);
        Type inType = (Type)reqContext.get(REQUEST_TYPE);
        Class respClass = (Class)reqContext.get(RESPONSE_CLASS);
        Type outType = (Type)reqContext.get(RESPONSE_TYPE);
        return this.doChainedInvocation(httpMethod, headers, body, requestClass, inType, respClass, outType, exchange, invContext);
    }

    /*
     * Loose catch block
     */
    protected Response doChainedInvocation(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> requestClass, Type inGenericType, Class<?> responseClass, Type outGenericType, Exchange exchange, Map<String, Object> invContext) {
        Bus configuredBus = this.getConfiguration().getBus();
        Bus origBus = BusFactory.getAndSetThreadDefaultBus(configuredBus);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            ClassLoader loader = configuredBus.getExtension(ClassLoader.class);
            if (loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader(loader);
            }
            URI uri = this.getCurrentURI();
            Message m = this.createMessage(body, httpMethod, headers, uri, exchange, invContext, false);
            Map<String, Object> reqContext = this.getRequestContext(m);
            reqContext.put("org.apache.cxf.request.method", httpMethod);
            reqContext.put(REQUEST_CLASS, requestClass);
            reqContext.put(REQUEST_TYPE, inGenericType);
            reqContext.put(RESPONSE_CLASS, responseClass);
            reqContext.put(RESPONSE_TYPE, outGenericType);
            if (body != null) {
                m.getInterceptorChain().add(new BodyWriter());
            }
            this.setPlainOperationNameProperty(m, httpMethod + ":" + uri.toString());
            try {
                m.getInterceptorChain().doIntercept(m);
            }
            catch (Exception ex) {
                m.setContent(Exception.class, ex);
            }
            try {
                Object[] results = this.preProcessResult(m);
                if (results != null && results.length == 1) {
                    Response response = (Response)results[0];
                    return response;
                }
            }
            catch (Exception ex) {
                throw ex instanceof ServerWebApplicationException ? (ServerWebApplicationException)((Object)ex) : (ex instanceof ClientWebApplicationException ? new ClientWebApplicationException(ex) : new RuntimeException(ex));
            }
            Response response = null;
            Object entity = null;
            try {
                response = this.handleResponse(m, responseClass, outGenericType);
                entity = response.getEntity();
                Response response2 = response;
                return response2;
            }
            catch (RuntimeException ex) {
                entity = ex;
                throw ex;
            }
            finally {
                this.completeExchange(entity, m.getExchange(), false);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (origLoader != null) {
                origLoader.reset();
            }
            if (origBus != configuredBus) {
                BusFactory.setThreadDefaultBus(origBus);
            }
        }
    }

    protected Response handleResponse(Message outMessage, Class<?> responseClass, Type genericType) {
        try {
            int status;
            Response.ResponseBuilder rb = this.setResponseBuilder(outMessage, outMessage.getExchange());
            Response currentResponse = rb.clone().build();
            Object entity = this.readBody(currentResponse, outMessage, responseClass, genericType, new Annotation[0]);
            if (entity == null && (status = currentResponse.getStatus()) >= 400) {
                entity = currentResponse.getEntity();
            }
            rb = JAXRSUtils.fromResponse(currentResponse);
            rb.entity(entity instanceof Response ? ((Response)entity).getEntity() : entity);
            Response response = rb.build();
            return response;
        }
        catch (Throwable ex) {
            throw ex instanceof ClientWebApplicationException ? (ClientWebApplicationException)ex : new ClientWebApplicationException(ex);
        }
        finally {
            ProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    static void copyProperties(Client toClient, Client fromClient) {
        AbstractClient newClient = WebClient.toAbstractClient(toClient);
        AbstractClient oldClient = WebClient.toAbstractClient(fromClient);
        newClient.setConfiguration(oldClient.getConfiguration());
    }

    private static AbstractClient toAbstractClient(Object client) {
        if (client instanceof AbstractClient) {
            return (AbstractClient)client;
        }
        return (AbstractClient)((InvocationHandlerAware)client).getInvocationHandler();
    }

    static JAXRSClientFactoryBean getBean(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (configLocation != null) {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(configLocation);
            bean.setBus(bus);
        }
        bean.setAddress(baseAddress);
        return bean;
    }

    static ClientState getClientState(Client client) {
        ClientState clientState = null;
        if (client instanceof WebClient) {
            clientState = ((AbstractClient)client).getState();
        } else if (client instanceof InvocationHandlerAware) {
            Object handler = ((InvocationHandlerAware)((Object)client)).getInvocationHandler();
            clientState = ((AbstractClient)handler).getState();
        }
        return clientState;
    }

    static URI convertStringToURI(String baseAddress) {
        try {
            return URI.create(baseAddress);
        }
        catch (RuntimeException ex) {
            if (baseAddress.startsWith("http")) {
                return new UriBuilderImpl().uriAsTemplate(baseAddress).build(new Object[0]);
            }
            throw ex;
        }
    }

    private class BodyWriter
    extends AbstractOutDatabindingInterceptor {
        public BodyWriter() {
            super("write");
        }

        public void handleMessage(Message outMessage) throws Fault {
            OutputStream os = outMessage.getContent(OutputStream.class);
            XMLStreamWriter writer = outMessage.getContent(XMLStreamWriter.class);
            if (os == null && writer == null) {
                return;
            }
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
            Object body = objs.get(0);
            Map<String, Object> requestContext = WebClient.this.getRequestContext(outMessage);
            Class requestClass = null;
            Type requestType = null;
            if (requestContext != null) {
                requestClass = (Class)requestContext.get(WebClient.REQUEST_CLASS);
                requestType = (Type)requestContext.get(WebClient.REQUEST_TYPE);
            }
            boolean isAssignable = requestClass != null && requestClass.isAssignableFrom(body.getClass());
            try {
                WebClient.this.writeBody(body, outMessage, requestClass == null || !isAssignable ? body.getClass() : requestClass, requestType == null || !isAssignable ? body.getClass() : requestType, new Annotation[0], (MultivaluedMap<String, Object>)headers, os);
                if (os != null) {
                    os.flush();
                }
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }
}

