/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.policy.PolicyDataEngine;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Assertor;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.CXFAuthenticator;
import org.apache.cxf.transport.http.ChunkedUtil;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.Cookies;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.ProxyFactory;
import org.apache.cxf.transport.http.TrustDecisionUtil;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.cxf.transport.http.auth.DigestAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthHeader;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transport.http.auth.SpnegoAuthSupplier;
import org.apache.cxf.transport.http.policy.impl.ClientPolicyCalculator;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class HTTPConduit
extends AbstractConduit
implements Configurable,
Assertor,
PropertyChangeListener {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    private static final String KEY_VISITED_URLS = "VisitedURLs";
    private static final String KEY_AUTH_URLS = "AuthURLs";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private static boolean hasLoggedAsyncWarning;
    private static final String SC_HTTP_CONDUIT_SUFFIX = ".http-conduit";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_PUT_METHOD = "PUT";
    protected HttpsURLConnectionFactory connectionFactory;
    private final Bus bus;
    private final EndpointInfo endpointInfo;
    private URL defaultEndpointURL;
    private String defaultEndpointURLString;
    private boolean fromEndpointReferenceType;
    private ProxyFactory proxyFactory;
    private HTTPClientPolicy clientSidePolicy;
    private AuthorizationPolicy authorizationPolicy;
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    private TLSClientParameters tlsClientParameters;
    private MessageTrustDecider trustDecider;
    private HttpAuthSupplier authSupplier;
    private HttpAuthSupplier proxyAuthSupplier;
    private Cookies cookies;
    private CertConstraints certConstraints;

    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(HTTPConduit.getTargetReference(ei, t, b));
        this.bus = b;
        this.endpointInfo = ei;
        if (t != null) {
            this.fromEndpointReferenceType = true;
        }
        this.proxyFactory = new ProxyFactory();
        this.connectionFactory = new HttpsURLConnectionFactory();
        this.cookies = new Cookies();
        this.updateClientPolicy();
        CXFAuthenticator.addAuthenticator();
    }

    private void updateClientPolicy() {
        PolicyDataEngine policyEngine = this.bus.getExtension(PolicyDataEngine.class);
        if (policyEngine != null && this.endpointInfo.getService() != null) {
            this.clientSidePolicy = policyEngine.getClientEndpointPolicy(this.endpointInfo, this, new ClientPolicyCalculator());
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public final String getConduitName() {
        return this.endpointInfo.getName() + SC_HTTP_CONDUIT_SUFFIX;
    }

    private static void configureConduitFromEndpointInfo(HTTPConduit conduit, EndpointInfo endpointInfo) {
        if (conduit.getClient() == null) {
            conduit.setClient(endpointInfo.getTraversedExtensor(new HTTPClientPolicy(), HTTPClientPolicy.class));
        }
        if (conduit.getAuthorization() == null) {
            conduit.setAuthorization(endpointInfo.getTraversedExtensor(new AuthorizationPolicy(), AuthorizationPolicy.class));
        }
        if (conduit.getProxyAuthorization() == null) {
            conduit.setProxyAuthorization(endpointInfo.getTraversedExtensor(new ProxyAuthorizationPolicy(), ProxyAuthorizationPolicy.class));
        }
        if (conduit.getTlsClientParameters() == null) {
            conduit.setTlsClientParameters(endpointInfo.getTraversedExtensor(null, TLSClientParameters.class));
        }
        if (conduit.getTrustDecider() == null) {
            conduit.setTrustDecider(endpointInfo.getTraversedExtensor(null, MessageTrustDecider.class));
        }
        if (conduit.getAuthSupplier() == null) {
            conduit.setAuthSupplier(endpointInfo.getTraversedExtensor(null, HttpAuthSupplier.class));
        }
    }

    private void logConfig() {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        if (this.trustDecider == null) {
            LOG.log(Level.FINE, "No Trust Decider configured for Conduit '" + this.getConduitName() + "'");
        } else {
            LOG.log(Level.FINE, "Message Trust Decider of class '" + this.trustDecider.getClass().getName() + "' with logical name of '" + this.trustDecider.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.authSupplier == null) {
            LOG.log(Level.FINE, "No Auth Supplier configured for Conduit '" + this.getConduitName() + "'");
        } else {
            LOG.log(Level.FINE, "HttpAuthSupplier of class '" + this.authSupplier.getClass().getName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.tlsClientParameters != null) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for TLS " + "keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom() + "Disable Common Name (CN) Check: " + this.tlsClientParameters.isDisableCNCheck());
        } else {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for plain http.");
        }
    }

    protected void finalizeConfig() {
        HTTPConduit.configureConduitFromEndpointInfo(this, this.endpointInfo);
        this.logConfig();
        if (this.getClient().getDecoupledEndpoint() != null) {
            this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", this.getClient().getDecoupledEndpoint());
        }
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
            this.clientSidePolicy.addPropertyChangeListener(this);
        }
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies.getSessionCookies();
    }

    private HttpURLConnection createConnection(Message message, URL url) throws IOException {
        HTTPClientPolicy csPolicy = this.getClient(message);
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, url);
        return this.connectionFactory.createConnection(this.tlsClientParameters, proxy, url);
    }

    @Override
    public void prepare(Message message) throws IOException {
        URL currentURL = this.setupURL(message);
        boolean needToCacheRequest = false;
        HTTPClientPolicy csPolicy = this.getClient(message);
        HttpURLConnection connection = this.createConnection(message, currentURL);
        connection.setDoOutput(true);
        int ctimeout = HTTPConduit.determineConnectionTimeout(message, csPolicy);
        connection.setConnectTimeout(ctimeout);
        int rtimeout = HTTPConduit.determineReceiveTimeout(message, csPolicy);
        connection.setReadTimeout(rtimeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        connection.setRequestMethod(null != httpRequestMethod ? httpRequestMethod : HTTP_POST_METHOD);
        boolean isChunking = false;
        int chunkThreshold = 0;
        AuthorizationPolicy effectiveAuthPolicy = this.getEffectiveAuthPolicy(message);
        if (this.authSupplier == null) {
            this.authSupplier = this.createAuthSupplier(effectiveAuthPolicy.getAuthorizationType());
        }
        if (this.proxyAuthSupplier == null) {
            this.proxyAuthSupplier = this.createAuthSupplier(this.proxyAuthorizationPolicy.getAuthorizationType());
        }
        if (this.authSupplier.requiresRequestCaching()) {
            needToCacheRequest = true;
            isChunking = false;
            LOG.log(Level.FINE, "Auth Supplier, but no Premeptive User Pass or Digest auth (nonce may be stale) We must cache request.");
        }
        if (csPolicy.isAutoRedirect()) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "AutoRedirect is turned on.");
        }
        if (csPolicy.getMaxRetransmits() > 0) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "MaxRetransmits is set > 0.");
        }
        if (csPolicy.isAllowChunking() && this.isChunkingSupported(message, connection.getRequestMethod())) {
            isChunking = true;
            chunkThreshold = csPolicy.getChunkingThreshold();
            if (chunkThreshold <= 0) {
                chunkThreshold = 0;
                connection.setChunkedStreamingMode(-1);
            }
        }
        this.cookies.writeToMessageHeaders(message);
        message.put(KEY_HTTP_CONNECTION, connection);
        if (this.certConstraints != null) {
            message.put(CertConstraints.class.getName(), this.certConstraints);
            message.getInterceptorChain().add(CertConstraintsInterceptor.INSTANCE);
        }
        this.setHeadersByAuthorizationPolicy(message, currentURL);
        new Headers(message).setFromClientPolicy(this.getClient(message));
        message.setContent(OutputStream.class, this.createOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold));
    }

    protected boolean isChunkingSupported(Message message, String httpMethod) {
        Object obj;
        MessageContentsList objs;
        if (HTTP_POST_METHOD.equals(httpMethod)) {
            return true;
        }
        return HTTP_PUT_METHOD.equals(httpMethod) && (objs = MessageContentsList.getContentsList(message)) != null && objs.size() > 0 && ((obj = objs.get(0)).getClass() != String.class || obj.getClass() == String.class && ((String)obj).length() > 0);
    }

    protected OutputStream createOutputStream(Message message, HttpURLConnection connection, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) {
        return new WrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName());
    }

    private HttpAuthSupplier createAuthSupplier(String authType) {
        if ("Negotiate".equals(authType)) {
            return new SpnegoAuthSupplier();
        }
        if ("Digest".equals(authType)) {
            return new DigestAuthSupplier();
        }
        return new DefaultBasicAuthSupplier();
    }

    private static int determineReceiveTimeout(Message message, HTTPClientPolicy csPolicy) {
        long rtimeout = csPolicy.getReceiveTimeout();
        if (message.get("javax.xml.ws.client.receiveTimeout") != null) {
            Object obj = message.get("javax.xml.ws.client.receiveTimeout");
            try {
                rtimeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.receiveTimeout", obj.toString()});
            }
        }
        if (rtimeout > Integer.MAX_VALUE) {
            rtimeout = Integer.MAX_VALUE;
        }
        return (int)rtimeout;
    }

    private static int determineConnectionTimeout(Message message, HTTPClientPolicy csPolicy) {
        long ctimeout = csPolicy.getConnectionTimeout();
        if (message.get("javax.xml.ws.client.connectionTimeout") != null) {
            Object obj = message.get("javax.xml.ws.client.connectionTimeout");
            try {
                ctimeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.connectionTimeout", obj.toString()});
            }
        }
        if (ctimeout > Integer.MAX_VALUE) {
            ctimeout = Integer.MAX_VALUE;
        }
        return (int)ctimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Message msg) throws IOException {
        InputStream in = msg.getContent(InputStream.class);
        try {
            if (in != null) {
                byte[] buffer = new byte[1024];
                for (int count = 0; in.read(buffer) != -1 && count < 25; ++count) {
                }
            }
        }
        finally {
            super.close(msg);
        }
    }

    private URL setupURL(Message message) throws MalformedURLException {
        String result = (String)message.get(Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get(Message.PATH_INFO);
        String queryString = (String)message.get(Message.QUERY_STRING);
        if (result == null) {
            if (pathInfo == null && queryString == null) {
                URL url = this.getURL();
                message.put(Message.ENDPOINT_ADDRESS, this.defaultEndpointURLString);
                return url;
            }
            result = this.getURL().toString();
            message.put(Message.ENDPOINT_ADDRESS, result);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return new URL(result);
    }

    @Override
    public void close() {
        if (this.defaultEndpointURL != null) {
            try {
                URLConnection connect = this.defaultEndpointURL.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
        }
    }

    protected String getAddress() {
        if (this.defaultEndpointURL != null) {
            return this.defaultEndpointURLString;
        }
        if (this.fromEndpointReferenceType) {
            return this.getTarget().getAddress().getValue();
        }
        return this.endpointInfo.getAddress();
    }

    protected URL getURL() throws MalformedURLException {
        return this.getURL(true);
    }

    protected synchronized URL getURL(boolean createOnDemand) throws MalformedURLException {
        if (this.defaultEndpointURL == null && createOnDemand) {
            if (this.fromEndpointReferenceType && this.getTarget().getAddress().getValue() != null) {
                this.defaultEndpointURL = new URL(this.getTarget().getAddress().getValue());
                this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
                return this.defaultEndpointURL;
            }
            if (this.endpointInfo.getAddress() == null) {
                throw new MalformedURLException("Invalid address. Endpoint address cannot be null.");
            }
            this.defaultEndpointURL = new URL(this.endpointInfo.getAddress());
            this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
        }
        return this.defaultEndpointURL;
    }

    private void setHeadersByAuthorizationPolicy(Message message, URL url) {
        String proxyAuthString;
        Headers headers = new Headers(message);
        AuthorizationPolicy effectiveAuthPolicy = this.getEffectiveAuthPolicy(message);
        String authString = this.authSupplier.getAuthorization(effectiveAuthPolicy, url, message, null);
        if (authString != null) {
            headers.setAuthorization(authString);
        }
        if ((proxyAuthString = this.authSupplier.getAuthorization(this.proxyAuthorizationPolicy, url, message, null)) != null) {
            headers.setProxyAuthorization(proxyAuthString);
        }
    }

    @Override
    public String getBeanName() {
        if (this.endpointInfo.getName() != null) {
            return this.endpointInfo.getName().toString() + SC_HTTP_CONDUIT_SUFFIX;
        }
        return null;
    }

    public AuthorizationPolicy getEffectiveAuthPolicy(Message message) {
        AuthorizationPolicy authPolicy = this.getAuthorization();
        AuthorizationPolicy newPolicy = message.get(AuthorizationPolicy.class);
        AuthorizationPolicy effectivePolicy = newPolicy;
        if (effectivePolicy == null) {
            effectivePolicy = authPolicy;
        }
        if (effectivePolicy == null) {
            effectivePolicy = new AuthorizationPolicy();
        }
        return effectivePolicy;
    }

    public AuthorizationPolicy getAuthorization() {
        return this.authorizationPolicy;
    }

    public void setAuthorization(AuthorizationPolicy authorization) {
        this.authorizationPolicy = authorization;
    }

    public HTTPClientPolicy getClient(Message message) {
        ClientPolicyCalculator cpc = new ClientPolicyCalculator();
        HTTPClientPolicy pol = message.get(HTTPClientPolicy.class);
        pol = pol != null ? cpc.intersect(pol, this.clientSidePolicy) : this.clientSidePolicy;
        PolicyDataEngine policyDataEngine = this.bus.getExtension(PolicyDataEngine.class);
        if (policyDataEngine == null) {
            return pol;
        }
        return policyDataEngine.getPolicy(message, pol, cpc);
    }

    public HTTPClientPolicy getClient() {
        return this.clientSidePolicy;
    }

    public void setClient(HTTPClientPolicy client) {
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
        }
        this.clientSidePolicy = client;
        this.clientSidePolicy.removePropertyChangeListener(this);
        this.clientSidePolicy.addPropertyChangeListener(this);
        this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", client.getDecoupledEndpoint());
    }

    public ProxyAuthorizationPolicy getProxyAuthorization() {
        return this.proxyAuthorizationPolicy;
    }

    public void setProxyAuthorization(ProxyAuthorizationPolicy proxyAuthorization) {
        this.proxyAuthorizationPolicy = proxyAuthorization;
    }

    public TLSClientParameters getTlsClientParameters() {
        return this.tlsClientParameters;
    }

    public void setTlsClientParameters(TLSClientParameters params) {
        this.tlsClientParameters = params;
        if (this.tlsClientParameters != null) {
            CertificateConstraintsType constraints;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re) configured for TLS " + "keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
            if ((constraints = params.getCertConstraints()) != null) {
                this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints(constraints);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re)configured for plain http.");
        }
    }

    public MessageTrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void setTrustDecider(MessageTrustDecider decider) {
        this.trustDecider = decider;
    }

    public HttpAuthSupplier getAuthSupplier() {
        return this.authSupplier;
    }

    public void setAuthSupplier(HttpAuthSupplier supplier) {
        this.authSupplier = supplier;
    }

    public HttpAuthSupplier getProxyAuthSupplier() {
        return this.proxyAuthSupplier;
    }

    public void setProxyAuthSupplier(HttpAuthSupplier proxyAuthSupplier) {
        this.proxyAuthSupplier = proxyAuthSupplier;
    }

    private HttpURLConnection processRetransmit(HttpURLConnection origConnection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        int responseCode = origConnection.getResponseCode();
        if (message != null && message.getExchange() != null) {
            message.getExchange().put(Message.RESPONSE_CODE, responseCode);
        }
        HttpURLConnection connection = origConnection;
        switch (responseCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                connection = this.redirectRetransmit(origConnection, message, cachedStream);
                break;
            }
            case 401: {
                connection = this.authorizationRetransmit(origConnection, message, cachedStream);
                break;
            }
        }
        return connection;
    }

    private HttpURLConnection redirectRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (!this.getClient(message).isAutoRedirect()) {
            return connection;
        }
        URL newURL = this.extractLocation(connection.getHeaderFields());
        HTTPConduit.detectRedirectLoop(this.getConduitName(), connection.getURL(), newURL, message);
        if (newURL != null) {
            new Headers(message).removeAuthorizationHeaders();
            this.setHeadersByAuthorizationPolicy(message, newURL);
            connection.disconnect();
            return this.retransmit(newURL, message, cachedStream);
        }
        return connection;
    }

    private HttpURLConnection authorizationRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        HttpAuthHeader authHeader = new HttpAuthHeader(connection.getHeaderField("WWW-Authenticate"));
        URL currentURL = connection.getURL();
        String realm = authHeader.getRealm();
        HTTPConduit.detectAuthorizationLoop(this.getConduitName(), message, currentURL, realm);
        AuthorizationPolicy effectiveAthPolicy = this.getEffectiveAuthPolicy(message);
        String authorizationToken = this.authSupplier.getAuthorization(effectiveAthPolicy, currentURL, message, authHeader.getFullHeader());
        if (authorizationToken == null) {
            return connection;
        }
        try {
            this.closeInputStream(connection);
        }
        catch (Throwable t) {
            // empty catch block
        }
        new Headers(message).setAuthorization(authorizationToken);
        this.cookies.writeToMessageHeaders(message);
        return this.retransmit(currentURL, message, cachedStream);
    }

    private HttpURLConnection retransmit(URL newURL, Message message, CacheAndWriteOutputStream stream) throws IOException {
        HTTPClientPolicy cp = this.getClient(message);
        HttpURLConnection connection = this.createConnection(message, newURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)cp.getConnectionTimeout());
        connection.setReadTimeout((int)cp.getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        message.put("http.retransmit.url", newURL.toString());
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        connection.setRequestMethod(null != httpRequestMethod ? httpRequestMethod : HTTP_POST_METHOD);
        message.put(KEY_HTTP_CONNECTION, connection);
        if (stream != null && stream.size() < Integer.MAX_VALUE) {
            connection.setFixedLengthStreamingMode((int)stream.size());
        }
        new Headers(message).setProtocolHeadersInConnection(connection);
        TrustDecisionUtil.makeTrustDecision(this.trustDecider, message, connection, this.getConduitName());
        if (connection.getRequestMethod().equals("GET")) {
            return connection;
        }
        OutputStream out = connection.getOutputStream();
        stream.writeCacheTo(out);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Conduit \"" + this.getConduitName() + "\" Retransmit message to: " + connection.getURL() + ": " + new String(stream.getBytes()));
        }
        return connection;
    }

    private static void detectAuthorizationLoop(String conduitName, Message message, URL currentURL, String realm) throws IOException {
        HashSet<String> authURLs = (HashSet<String>)message.get(KEY_AUTH_URLS);
        if (authURLs == null) {
            authURLs = new HashSet<String>();
            message.put(KEY_AUTH_URLS, authURLs);
        }
        if (authURLs.contains(currentURL.toString() + realm)) {
            String logMessage = "Authorization loop detected on Conduit \"" + conduitName + "\" on URL \"" + currentURL + "\" with realm \"" + realm + "\"";
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, logMessage);
            }
            throw new IOException(logMessage);
        }
        authURLs.add(currentURL.toString() + realm);
    }

    private static void detectRedirectLoop(String conduitName, URL lastURL, URL newURL, Message message) throws IOException {
        HashSet<String> visitedURLs = (HashSet<String>)message.get(KEY_VISITED_URLS);
        if (visitedURLs == null) {
            visitedURLs = new HashSet<String>();
            message.put(KEY_VISITED_URLS, visitedURLs);
        }
        visitedURLs.add(lastURL.toString());
        if (newURL != null && visitedURLs.contains(newURL.toString())) {
            String msg = "Redirect loop detected on Conduit '" + conduitName + "' on '" + newURL + "'";
            LOG.log(Level.INFO, msg);
            throw new IOException(msg);
        }
    }

    private URL extractLocation(Map<String, List<String>> headers) throws MalformedURLException {
        for (Map.Entry<String, List<String>> head : headers.entrySet()) {
            List<String> locs;
            if (!"Location".equalsIgnoreCase(head.getKey()) || (locs = head.getValue()) == null || locs.size() <= 0) continue;
            String location = locs.get(0);
            if (location != null) {
                return new URL(location);
            }
            return null;
        }
        return null;
    }

    @Override
    public void assertMessage(Message message) {
        PolicyDataEngine policyDataEngine = this.bus.getExtension(PolicyDataEngine.class);
        policyDataEngine.assertMessage(message, this.getClient(), new ClientPolicyCalculator());
    }

    protected void closeInputStream(HttpURLConnection connection) throws IOException {
        InputStream ins = connection.getErrorStream();
        if (ins == null) {
            ins = connection.getInputStream();
        }
        if (ins != null) {
            IOUtils.consume(ins);
            ins.close();
        }
    }

    @Override
    public boolean canAssert(QName type) {
        return new ClientPolicyCalculator().equals(type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.clientSidePolicy && "decoupledEndpoint".equals(evt.getPropertyName())) {
            this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", evt.getNewValue());
        }
    }

    private void handleHttpRetryException(HttpRetryException e, HttpURLConnection connection) throws IOException {
        String msg = "HTTP response '" + e.responseCode() + ": " + connection.getResponseMessage() + "' invoking " + connection.getURL();
        switch (e.responseCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                msg = msg + " that returned location header '" + e.getLocation() + "'";
                break;
            }
            case 401: {
                if (this.authorizationPolicy == null || this.authorizationPolicy.getUserName() == null) {
                    msg = msg + " with NO authorization username configured in conduit " + this.getConduitName();
                    break;
                }
                msg = msg + " with authorization username '" + this.authorizationPolicy.getUserName() + "'";
                break;
            }
            case 407: {
                msg = this.proxyAuthorizationPolicy == null || this.proxyAuthorizationPolicy.getUserName() == null ? msg + " with NO proxy authorization configured in conduit " + this.getConduitName() : msg + " with proxy authorization username '" + this.proxyAuthorizationPolicy.getUserName() + "'";
                if (this.clientSidePolicy == null || this.clientSidePolicy.getProxyServer() == null) {
                    if (connection.usingProxy()) {
                        msg = msg + " using a proxy even if NONE is configured in CXF conduit " + this.getConduitName() + " (maybe one is configured by java.net.ProxySelector)";
                        break;
                    }
                    msg = msg + " but NO proxy was used by the connection (none configured in cxf conduit and none selected by java.net.ProxySelector)";
                    break;
                }
                msg = msg + " using " + (Object)((Object)this.clientSidePolicy.getProxyServerType()) + " proxy " + this.clientSidePolicy.getProxyServer() + ":" + this.clientSidePolicy.getProxyServerPort();
                break;
            }
        }
        throw (IOException)new IOException(msg).initCause(e);
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange(new ExchangeImpl());
            inMessage.getExchange().put(Bus.class, HTTPConduit.this.bus);
            inMessage.put("decoupled.channel.message", Boolean.TRUE);
            Headers.getSetProtocolHeaders(inMessage);
            inMessage.put(Message.RESPONSE_CODE, 200);
            inMessage.remove("HTTP.REQUEST");
            inMessage.remove("HTTP.RESPONSE");
            inMessage.remove("org.apache.cxf.async.post.response.dispatch");
            try {
                InputStream in = inMessage.getContent(InputStream.class);
                if (in != null) {
                    CachedOutputStream cos = new CachedOutputStream();
                    IOUtils.copy(in, cos);
                    inMessage.setContent(InputStream.class, cos.getInputStream());
                }
                HTTPConduit.this.incomingObserver.onMessage(inMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WrappedOutputStream
    extends AbstractThresholdOutputStream {
        protected HttpURLConnection connection;
        protected boolean cachingForRetransmission;
        protected final boolean chunking;
        protected CacheAndWriteOutputStream cachedStream;
        protected Message outMessage;
        protected String conduitName;

        protected WrappedOutputStream(Message outMessage, HttpURLConnection connection, boolean possibleRetransmit, boolean isChunking, int chunkThreshold, String conduitName) {
            super(chunkThreshold);
            this.outMessage = outMessage;
            this.connection = connection;
            this.cachingForRetransmission = possibleRetransmit;
            this.chunking = isChunking;
            this.conduitName = conduitName;
        }

        protected WrappedOutputStream(WrappedOutputStream wos) {
            super(wos.threshold);
            this.outMessage = wos.outMessage;
            this.connection = wos.connection;
            this.cachingForRetransmission = wos.cachingForRetransmission;
            this.chunking = wos.chunking;
            this.conduitName = wos.conduitName;
        }

        @Override
        public void thresholdNotReached() {
            if (this.chunking) {
                this.connection.setFixedLengthStreamingMode(this.buffer.size());
            }
        }

        @Override
        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(HTTPConduit.this.getClient().getChunkLength());
            }
        }

        @Override
        protected void onFirstWrite() throws IOException {
            try {
                this.handleHeadersTrustCaching();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("HTTPS hostname wrong:")) {
                    throw new IOException("The https URL hostname does not match the Common Name (CN) on the server certificate in the client's truststore.  Make sure server certificate is correct, or to disable this check (NOT recommended for production) set the CXF client TLS configuration property \"disableCNCheck\" to true.");
                }
                throw e;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending " + this.connection.getRequestMethod() + " Message with Headers to " + this.connection.getURL() + " Conduit :" + this.conduitName + "\n");
            }
        }

        protected void handleHeadersTrustCaching() throws IOException {
            new Headers(this.outMessage).setProtocolHeadersInConnection(this.connection);
            TrustDecisionUtil.makeTrustDecision(HTTPConduit.this.trustDecider, this.outMessage, this.connection, this.conduitName);
            if (!HTTPConduit.HTTP_POST_METHOD.equals(this.connection.getRequestMethod()) && !HTTPConduit.HTTP_PUT_METHOD.equals(this.connection.getRequestMethod())) {
                return;
            }
            if (this.outMessage.get("org.apache.cxf.post.empty") != null) {
                return;
            }
            OutputStream cout = null;
            try {
                cout = this.connection.getOutputStream();
            }
            catch (SocketException e) {
                if ("Socket Closed".equals(e.getMessage())) {
                    this.connection.connect();
                    cout = this.connection.getOutputStream();
                }
                throw e;
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(cout);
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = cout;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.buffer != null && this.buffer.size() > 0) {
                    this.thresholdNotReached();
                    LoadingByteArrayOutputStream tmp = this.buffer;
                    this.buffer = null;
                    super.write(tmp.getRawBytes(), 0, tmp.size());
                }
                if (!this.written) {
                    this.handleHeadersTrustCaching();
                }
                if (!this.cachingForRetransmission) {
                    super.close();
                } else if (this.cachedStream != null) {
                    super.flush();
                    this.cachedStream.getOut().close();
                    this.cachedStream.closeFlowthroughStream();
                }
                try {
                    this.handleResponse();
                }
                finally {
                    if (this.cachingForRetransmission && this.cachedStream != null) {
                        this.cachedStream.close();
                    }
                }
            }
            catch (HttpRetryException e) {
                HTTPConduit.this.handleHttpRetryException(e, this.connection);
            }
            catch (IOException e) {
                String url = this.connection.getURL().toString();
                String origMessage = e.getMessage();
                if (origMessage != null && origMessage.contains(url)) {
                    throw e;
                }
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, IOException.class);
            }
            catch (RuntimeException e) {
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, RuntimeException.class);
            }
        }

        private <T extends Exception> T mapException(String msg, T ex, Class<T> cls) {
            Object ex2 = ex;
            try {
                ex2 = (Exception)cls.cast(ex.getClass().getConstructor(String.class).newInstance(msg));
                ((Throwable)ex2).initCause(ex);
            }
            catch (Throwable e) {
                ex2 = ex;
            }
            return (T)ex2;
        }

        protected void handleRetransmits() throws IOException {
            if (this.cachedStream != null || "GET".equals(this.connection.getRequestMethod()) && HTTPConduit.this.getClient().isAutoRedirect()) {
                if (LOG.isLoggable(Level.FINE) && this.cachedStream != null) {
                    LOG.fine("Conduit \"" + HTTPConduit.this.getConduitName() + "\" Transmit cached message to: " + this.connection.getURL() + ": " + new String(this.cachedStream.getBytes()));
                }
                int maxRetransmits = this.getMaxRetransmits();
                HTTPConduit.this.cookies.readFromConnection(this.connection);
                HttpURLConnection oldcon = null;
                for (int nretransmits = 0; this.connection != oldcon && (maxRetransmits < 0 || nretransmits < maxRetransmits); ++nretransmits) {
                    oldcon = this.connection;
                    this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                }
            }
        }

        private int getMaxRetransmits() {
            HTTPClientPolicy policy = HTTPConduit.this.getClient(this.outMessage);
            return policy == null ? -1 : policy.getMaxRetransmits();
        }

        protected void handleResponse() throws IOException {
            this.handleRetransmits();
            if (this.outMessage == null || this.outMessage.getExchange() == null || this.outMessage.getExchange().isSynchronous()) {
                this.handleResponseInternal();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            WrappedOutputStream.this.handleResponseInternal();
                        }
                        catch (Exception e) {
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).abort();
                            WrappedOutputStream.this.outMessage.setContent(Exception.class, e);
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).unwind(WrappedOutputStream.this.outMessage);
                            WrappedOutputStream.this.outMessage.getInterceptorChain().getFaultObserver().onMessage(WrappedOutputStream.this.outMessage);
                        }
                    }
                };
                HTTPClientPolicy policy = HTTPConduit.this.getClient(this.outMessage);
                try {
                    Executor ex = this.outMessage.getExchange().get(Executor.class);
                    if (ex == null) {
                        WorkQueueManager mgr = this.outMessage.getExchange().get(Bus.class).getExtension(WorkQueueManager.class);
                        AutomaticWorkQueue qu = mgr.getNamedWorkQueue("http-conduit");
                        if (qu == null) {
                            qu = mgr.getAutomaticWorkQueue();
                        }
                        long timeout = 5000L;
                        if (policy != null && policy.isSetAsyncExecuteTimeout()) {
                            timeout = policy.getAsyncExecuteTimeout();
                        }
                        if (timeout > 0L) {
                            qu.execute(runnable, timeout);
                        } else {
                            qu.execute(runnable);
                        }
                    } else {
                        this.outMessage.getExchange().put(Executor.class.getName() + ".USING_SPECIFIED", Boolean.TRUE);
                        ex.execute(runnable);
                    }
                }
                catch (RejectedExecutionException rex) {
                    if (policy != null && policy.isSetAsyncExecuteTimeoutRejection() && policy.isAsyncExecuteTimeoutRejection()) {
                        throw rex;
                    }
                    if (!hasLoggedAsyncWarning) {
                        LOG.warning("EXECUTOR_FULL_WARNING");
                        hasLoggedAsyncWarning = true;
                    }
                    LOG.fine("EXECUTOR_FULL");
                    this.handleResponseInternal();
                }
            }
        }

        private boolean isOneway(Exchange exchange) {
            return exchange != null && exchange.isOneWay();
        }

        private boolean doProcessResponse(Message message) {
            if (!this.isOneway(message.getExchange())) {
                return true;
            }
            return MessageUtils.getContextualBoolean(message, "org.apache.cxf.transport.processOneWayResponse", false);
        }

        protected void handleResponseInternal() throws IOException {
            Exchange exchange = this.outMessage.getExchange();
            int responseCode = this.connection.getResponseCode();
            if (responseCode == -1) {
                LOG.warning("HTTP Response code appears to be corrupted");
            }
            if (exchange != null) {
                exchange.put(Message.RESPONSE_CODE, responseCode);
            }
            this.logResponseInfo(responseCode);
            boolean noExceptions = MessageUtils.isTrue(this.outMessage.getContextualProperty("org.apache.cxf.http.no_io_exceptions"));
            if (responseCode >= 400 && responseCode != 500 && !noExceptions) {
                throw new HTTPException(responseCode, this.connection.getResponseMessage(), this.connection.getURL());
            }
            InputStream in = null;
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            new Headers(inMessage).readFromConnection(this.connection);
            inMessage.put(Message.RESPONSE_CODE, responseCode);
            HTTPConduit.this.cookies.readFromConnection(this.connection);
            if (this.isOneway(exchange) || 202 == responseCode) {
                in = ChunkedUtil.getPartialResponse(this.connection, responseCode);
                if (in == null || !this.doProcessResponse(this.outMessage)) {
                    Endpoint ep;
                    HTTPConduit.this.closeInputStream(this.connection);
                    if (this.isOneway(exchange) && responseCode > 300) {
                        throw new HTTPException(responseCode, this.connection.getResponseMessage(), this.connection.getURL());
                    }
                    ClientCallback cc = exchange.get(ClientCallback.class);
                    if (null != cc && null != (ep = exchange.getEndpoint()) && null != ep.getEndpointInfo() && null == ep.getEndpointInfo().getProperty("org.apache.cxf.ws.addressing.MAPAggregator.decoupledDestination")) {
                        cc.handleResponse(null, null);
                    }
                    if (in != null) {
                        in.close();
                    }
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
                if (this.cachingForRetransmission && this.cachedStream != null) {
                    this.cachedStream.close();
                }
                this.cachedStream = null;
            }
            String ct = this.connection.getContentType();
            inMessage.put("Content-Type", ct);
            String charset = HttpHeaderHelper.findCharset(ct);
            String normalizedEncoding = HttpHeaderHelper.mapCharset(charset);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, charset).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put(Message.ENCODING, normalizedEncoding);
            if (in == null) {
                if (responseCode >= 400) {
                    in = this.connection.getErrorStream();
                    if (in == null) {
                        try {
                            in = this.connection.getInputStream();
                        }
                        catch (IOException ex) {}
                    }
                } else {
                    in = this.connection.getInputStream();
                }
            }
            if (in == null) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            inMessage.setContent(InputStream.class, in);
            HTTPConduit.this.incomingObserver.onMessage(inMessage);
        }

        private void logResponseInfo(int responseCode) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response Code: " + responseCode + " Conduit: " + this.conduitName);
                LOG.fine("Content length: " + this.connection.getContentLength());
                Map<String, List<String>> headerFields = this.connection.getHeaderFields();
                if (null != headerFields) {
                    String newLine = SystemPropertyAction.getProperty("line.separator");
                    StringBuilder buf = new StringBuilder();
                    buf.append("Header fields: " + newLine);
                    for (String headerKey : headerFields.keySet()) {
                        buf.append("    " + headerKey + ": " + headerFields.get(headerKey) + newLine);
                    }
                    LOG.fine(buf.toString());
                }
            }
        }
    }
}

