/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) {
        ProviderFactory providerFactory = ProviderFactory.getInstance(message);
        try {
            this.processResponse(providerFactory, message);
        }
        finally {
            Object rootInstance = message.getExchange().remove("service.root.instance");
            Object rootProvider = message.getExchange().remove("service.root.provider");
            if (rootInstance != null && rootProvider != null) {
                try {
                    ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
                }
                catch (Throwable tex) {
                    LOG.warning("Exception occurred during releasing the service instance, " + tex.getMessage());
                }
            }
            providerFactory.clearThreadLocalProxies();
            ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get("root.resource.class");
            if (cri != null) {
                cri.clearThreadLocalProxies();
            }
        }
    }

    private void processResponse(ProviderFactory providerFactory, Message message) {
        if (this.isResponseAlreadyHandled(message)) {
            return;
        }
        message.put("org.apache.cxf.rest.message", Boolean.TRUE);
        MessageContentsList objs = MessageContentsList.getContentsList(message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        Object responseObj = objs.get(0);
        Response response = null;
        if (responseObj instanceof Response) {
            response = (Response)responseObj;
        } else {
            int status = this.getStatus(message, responseObj != null ? 200 : 204);
            response = Response.status((int)status).entity(responseObj).build();
        }
        Exchange exchange = message.getExchange();
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class.getName());
        JAXRSUtils.runContainerResponseFilters(providerFactory, response, message, ori);
        Response updatedResponse = message.get(Response.class);
        if (updatedResponse != null) {
            response = updatedResponse;
        }
        List<ProviderInfo<ResponseHandler>> handlers = ProviderFactory.getInstance(message).getResponseHandlers();
        for (ProviderInfo<ResponseHandler> rh : handlers) {
            InjectionUtils.injectContexts(rh.getProvider(), rh, message.getExchange().getInMessage());
            Response r = rh.getProvider().handleResponse(message, ori, response);
            if (r == null) continue;
            response = r;
        }
        this.serializeMessage(message, response, ori, true);
    }

    private int getStatus(Message message, int defaultValue) {
        Object customStatus = message.getExchange().get(Message.RESPONSE_CODE);
        return customStatus == null ? defaultValue : (Integer)customStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeMessage(Message message, Response response, OperationResourceInfo ori, boolean firstTry) {
        boolean asyncResponse;
        Class<?> targetType;
        Type genericType;
        boolean ignoreWriters;
        Exchange exchange = message.getExchange();
        int status = response.getStatus();
        Object responseObj = response.getEntity();
        if (status == 200 && !this.isResponseNull(responseObj) && firstTry && ori != null && JAXRSUtils.headMethodPossible(ori.getHttpMethod(), (String)exchange.getInMessage().get("org.apache.cxf.request.method"))) {
            LOG.info(new org.apache.cxf.common.i18n.Message("HEAD_WITHOUT_ENTITY", BUNDLE, new Object[0]).toString());
            responseObj = null;
        }
        if (status == -1) {
            status = this.isResponseNull(responseObj) ? 204 : 200;
        }
        this.setResponseStatus(message, status);
        Map theHeaders = (Map)message.get(Message.PROTOCOL_HEADERS);
        if (firstTry && theHeaders != null) {
            theHeaders.putAll(response.getMetadata());
        } else {
            theHeaders = response.getMetadata();
        }
        MetadataMap<String, Object> responseHeaders = !(theHeaders instanceof MultivaluedMap) ? new MetadataMap<String, Object>(theHeaders) : (MetadataMap<String, Object>)((Object)theHeaders);
        message.put(Message.PROTOCOL_HEADERS, responseHeaders);
        this.setResponseDate(responseHeaders, firstTry);
        if (this.isResponseNull(responseObj)) {
            responseHeaders.putSingle("Content-Length", "0");
            return;
        }
        Object ignoreWritersProp = exchange.get("ignore.message.writers");
        boolean bl = ignoreWriters = ignoreWritersProp == null ? false : Boolean.valueOf(ignoreWritersProp.toString());
        if (ignoreWriters) {
            this.writeResponseToStream(message.getContent(OutputStream.class), responseObj);
            return;
        }
        List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message, response);
        Method invoked = null;
        if (firstTry) {
            Method method = invoked = ori == null ? null : (ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod());
        }
        if ((genericType = this.getGenericResponseType(invoked, responseObj, targetType = this.getRawResponseClass(invoked, responseObj, asyncResponse = exchange.get(AsyncResponse.class) != null), asyncResponse)) instanceof TypeVariable) {
            genericType = InjectionUtils.getSuperType(ori.getClassResourceInfo().getServiceClass(), (TypeVariable)genericType);
        }
        Annotation[] annotations = invoked != null ? invoked.getAnnotations() : new Annotation[]{};
        List<WriterInterceptor> writers = null;
        MediaType responseType = null;
        for (MediaType type : availableContentTypes) {
            writers = ProviderFactory.getInstance(message).createMessageBodyWriterInterceptor(targetType, genericType, annotations, type, message);
            if (writers == null) continue;
            responseType = type;
            break;
        }
        OutputStream outOriginal = message.getContent(OutputStream.class);
        if (writers == null) {
            message.put("Content-Type", "text/plain");
            message.put(Message.RESPONSE_CODE, 500);
            this.writeResponseErrorMessage(outOriginal, "NO_MSG_WRITER", targetType.getSimpleName());
            return;
        }
        boolean enabled = this.checkBufferingMode(message, writers, firstTry);
        Object entity = this.getEntity(responseObj);
        try {
            responseType = this.checkFinalContentType(responseType);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response content type is: " + responseType.toString());
            }
            message.put("Content-Type", responseType.toString());
            try {
                JAXRSUtils.writeMessageBody(writers, entity, targetType, genericType, annotations, responseType, responseHeaders, message);
                if (this.isResponseRedirected(message)) {
                    return;
                }
                Object newContentType = responseHeaders.getFirst("Content-Type");
                if (newContentType != null) {
                    message.put("Content-Type", newContentType.toString());
                }
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    message.setContent(OutputStream.class, outOriginal);
                    message.put(XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (IOException ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
        }
        catch (Throwable ex) {
            this.handleWriteException(message, response, ori, ex, entity, firstTry);
        }
    }

    private boolean isResponseNull(Object o) {
        return o == null || GenericEntity.class.isAssignableFrom(o.getClass()) && ((GenericEntity)o).getEntity() == null;
    }

    private Object getEntity(Object o) {
        return GenericEntity.class.isAssignableFrom(o.getClass()) ? ((GenericEntity)o).getEntity() : o;
    }

    private boolean checkBufferingMode(Message m, List<WriterInterceptor> writers, boolean firstTry) {
        if (!firstTry) {
            return false;
        }
        WriterInterceptor last = writers.get(writers.size() - 1);
        MessageBodyWriter<Object> w = ((WriterInterceptorMBW)last).getMBW();
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean enabled = MessageUtils.isTrue(outBuf);
        boolean configurableProvider = w instanceof AbstractConfigurableProvider;
        if (!enabled && outBuf == null && configurableProvider) {
            enabled = ((AbstractConfigurableProvider)w).getEnableBuffering();
        }
        if (enabled) {
            boolean streamingOn;
            boolean bl = streamingOn = configurableProvider ? ((AbstractConfigurableProvider)w).getEnableStreaming() : false;
            if (streamingOn) {
                m.setContent(XMLStreamWriter.class, new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, new CachedOutputStream());
            }
        }
        return enabled;
    }

    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        OutputStream os;
        XMLStreamWriter writer = null;
        writer = enabled ? m.getContent(XMLStreamWriter.class) : (XMLStreamWriter)m.get(XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = StaxUtils.createXMLStreamWriter(osOriginal);
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent(event, origWriter);
                }
            }
            m.setContent(XMLStreamWriter.class, null);
            return;
        }
        if (enabled && (os = m.getContent(OutputStream.class)) != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0L) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void handleWriteException(Message message, Response response, OperationResourceInfo ori, Throwable ex, Object responseObj, boolean firstTry) {
        OutputStream out = message.getContent(OutputStream.class);
        if (firstTry) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse != null) {
                this.serializeMessage(message, excResponse, ori, false);
                return;
            }
            ex.printStackTrace();
        }
        this.setResponseStatus(message, 500);
        this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, parameter);
            LOG.warning(message.toString());
            if (out != null) {
                out.write(message.toString().getBytes("UTF-8"));
            }
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message, Response response) {
        Object contentType = response.getMetadata().getFirst((Object)"Content-Type");
        if (contentType != null) {
            return Collections.singletonList(MediaType.valueOf((String)contentType.toString()));
        }
        Exchange exchange = message.getExchange();
        List<MediaType> produceTypes = null;
        OperationResourceInfo operation = exchange.get(OperationResourceInfo.class);
        produceTypes = operation != null ? operation.getProduceTypes() : Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        List<MediaType> acceptContentTypes = (List<MediaType>)exchange.get("Accept");
        if (acceptContentTypes == null) {
            acceptContentTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return JAXRSUtils.intersectMimeTypes(acceptContentTypes, produceTypes, true);
    }

    private Class<?> getRawResponseClass(Method invoked, Object targetObject, boolean async) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getRawType();
        }
        Class<?> targetClass = targetObject.getClass();
        Class<?> responseClass = async || invoked == null || !invoked.getReturnType().isAssignableFrom(targetClass) ? targetClass : invoked.getReturnType();
        return ClassHelper.getRealClassFromClass(responseClass);
    }

    private Type getGenericResponseType(Method invoked, Object targetObject, Class<?> targetType, boolean async) {
        if (GenericEntity.class.isAssignableFrom(targetObject.getClass())) {
            return ((GenericEntity)targetObject).getType();
        }
        if (async || invoked == null || !invoked.getReturnType().isAssignableFrom(targetType)) {
            return targetObject.getClass();
        }
        return invoked.getGenericReturnType();
    }

    private MediaType checkFinalContentType(MediaType mt) {
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if (mt.getParameters().containsKey("q")) {
            return MediaType.valueOf((String)JAXRSUtils.removeMediaTypeParameter(mt, "q"));
        }
        return mt;
    }

    private void setResponseDate(MultivaluedMap<String, Object> headers, boolean firstTry) {
        if (!firstTry) {
            return;
        }
        SimpleDateFormat format = HttpUtils.getHttpDateFormat();
        headers.putSingle((Object)"Date", (Object)format.format(new Date()));
    }

    private boolean isResponseAlreadyHandled(Message m) {
        return this.isResponseAlreadyCommited(m) || this.isResponseRedirected(m);
    }

    private boolean isResponseAlreadyCommited(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get("http.response.done"));
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get("http.request.redirected"));
    }

    private void writeResponseToStream(OutputStream os, Object responseObj) {
        try {
            byte[] bytes = responseObj.toString().getBytes("UTF-8");
            os.write(bytes, 0, bytes.length);
        }
        catch (Exception ex) {
            LOG.severe("Problem with writing the data to the output stream");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void setResponseStatus(Message message, int status) {
        message.put(Message.RESPONSE_CODE, status);
        boolean responseHeadersCopied = this.isResponseHeadersCopied(message);
        if (responseHeadersCopied) {
            HttpServletResponse response = (HttpServletResponse)message.get("HTTP.RESPONSE");
            response.setStatus(status);
        }
    }

    private boolean isResponseHeadersCopied(Message message) {
        return MessageUtils.isTrue(message.get("http.headers.copied"));
    }
}

