/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public abstract class AbstractSearchConditionVisitor<T, E>
implements SearchConditionVisitor<T, E> {
    private Map<String, String> fieldMap;
    private Map<String, Class<?>> primitiveFieldTypeMap;

    protected AbstractSearchConditionVisitor(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    protected String getRealPropertyName(String name) {
        if (this.fieldMap != null && this.fieldMap.containsKey(name)) {
            return this.fieldMap.get(name);
        }
        return name;
    }

    protected Class<?> getPrimitiveFieldClass(String name, Class<?> valueCls) {
        return this.getPrimitiveFieldClass(name, valueCls, null).getCls();
    }

    protected ClassValue getPrimitiveFieldClass(String name, Class<?> valueCls, Object value) {
        return this.getPrimitiveFieldClass(name, valueCls, valueCls, value);
    }

    protected ClassValue getPrimitiveFieldClass(String name, Class<?> valueCls, Type type, Object value) {
        return this.doGetPrimitiveFieldClass(name, valueCls, type, value, new HashSet<String>());
    }

    private ClassValue doGetPrimitiveFieldClass(String name, Class<?> valueCls, Type type, Object value, Set<String> set) {
        boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(valueCls);
        int index = name.indexOf(".");
        if (index != -1) {
            String[] names = name.split("\\.");
            name = name.substring(index + 1);
            if (value != null && !InjectionUtils.isPrimitive(valueCls)) {
                try {
                    String nextPart = names[1];
                    nextPart = nextPart.length() == 1 ? nextPart.toUpperCase() : Character.toUpperCase(nextPart.charAt(0)) + nextPart.substring(1);
                    Class<?> actualCls = isCollection ? InjectionUtils.getActualType(type) : valueCls;
                    Method m = actualCls.getMethod("get" + nextPart, new Class[0]);
                    if (isCollection) {
                        value = ((Collection)value).iterator().next();
                        set.add(names[0]);
                    }
                    value = m.invoke(value, new Object[0]);
                    valueCls = value.getClass();
                    type = m.getGenericReturnType();
                }
                catch (Throwable ex) {
                    throw new RuntimeException();
                }
                return this.doGetPrimitiveFieldClass(name, valueCls, type, value, set);
            }
        } else if (isCollection) {
            set.add(name);
            value = ((Collection)value).iterator().next();
            valueCls = value.getClass();
        }
        Class<?> cls = null;
        if (this.primitiveFieldTypeMap != null) {
            cls = this.primitiveFieldTypeMap.get(name);
        }
        if (cls == null) {
            cls = valueCls;
        }
        return new ClassValue(cls, value, set);
    }

    public void setPrimitiveFieldTypeMap(Map<String, Class<?>> primitiveFieldTypeMap) {
        this.primitiveFieldTypeMap = primitiveFieldTypeMap;
    }

    public SearchConditionVisitor<T, E> visitor() {
        return this;
    }

    protected class ClassValue {
        private Class<?> cls;
        private Object value;
        private Set<String> collectionProps;

        public ClassValue(Class<?> cls, Object value, Set<String> collectionProps) {
            this.cls = cls;
            this.value = value;
            this.collectionProps = collectionProps;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public void setCls(Class<?> cls) {
            this.cls = cls;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCollection(String name) {
            return this.collectionProps != null && this.collectionProps.contains(name);
        }
    }
}

