/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class SearchContextImpl
implements SearchContext {
    public static final String SEARCH_QUERY = "_search";
    public static final String SHORT_SEARCH_QUERY = "_s";
    private static final Logger LOG = LogUtils.getL7dLogger(SearchContextImpl.class);
    private Message message;

    public SearchContextImpl(Message message) {
        this.message = message;
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls) {
        return this.getCondition(null, cls);
    }

    @Override
    public <T> SearchCondition<T> getCondition(Class<T> cls, Map<String, String> beanProperties) {
        return this.getCondition(null, cls, beanProperties);
    }

    @Override
    public <T> SearchCondition<T> getCondition(String expression, Class<T> cls) {
        return this.getCondition(expression, cls, null);
    }

    @Override
    public <T> SearchCondition<T> getCondition(String expression, Class<T> cls, Map<String, String> beanProperties) {
        String theExpression;
        if (InjectionUtils.isPrimitive(cls)) {
            String errorMessage = "Primitive condition types are not supported";
            LOG.warning(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        SearchConditionParser<T> parser = this.getParser(cls, beanProperties);
        String string = theExpression = expression == null ? this.getSearchExpression() : expression;
        if (theExpression != null) {
            try {
                return parser.parse(theExpression);
            }
            catch (SearchParseException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSearchExpression() {
        String queryStr = (String)this.message.get(Message.QUERY_STRING);
        if (queryStr != null && (queryStr.contains(SHORT_SEARCH_QUERY) || queryStr.contains(SEARCH_QUERY))) {
            MultivaluedMap<String, String> params = JAXRSUtils.getStructuredParams(queryStr, "&", true, false);
            if (params.containsKey((Object)SHORT_SEARCH_QUERY)) {
                return (String)params.getFirst((Object)SHORT_SEARCH_QUERY);
            }
            return (String)params.getFirst((Object)SEARCH_QUERY);
        }
        return null;
    }

    private <T> SearchConditionParser<T> getParser(Class<T> cls, Map<String, String> beanProperties) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(4);
        props.put("search.date-format", (String)this.message.getContextualProperty("search.date-format"));
        props.put("search.timezone.support", (String)this.message.getContextualProperty("search.timezone.support"));
        props.put("search.lax.property.match", (String)this.message.getContextualProperty("search.lax.property.match"));
        Map<String, String> beanProps = null;
        beanProps = beanProperties == null ? CastUtils.cast((Map)this.message.getContextualProperty("search.bean.property.map")) : beanProperties;
        return new FiqlParser<T>(cls, props, beanProps);
    }
}

