/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;

public abstract class AbstractHTTPServlet
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = -8357252743467075117L;
    private static final List<String> KNOWN_HTTP_VERBS = Arrays.asList("POST", "GET", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE");
    private static final String STATIC_RESOURCES_PARAMETER = "static-resources-list";
    private static final String STATIC_WELCOME_FILE_PARAMETER = "static-welcome-file";
    private static final String REDIRECTS_PARAMETER = "redirects-list";
    private static final String REDIRECT_SERVLET_NAME_PARAMETER = "redirect-servlet-name";
    private static final String REDIRECT_SERVLET_PATH_PARAMETER = "redirect-servlet-path";
    private static final String REDIRECT_ATTRIBUTES_PARAMETER = "redirect-attributes";
    private static final String REDIRECT_QUERY_CHECK_PARAMETER = "redirect-query-check";
    private static final Map<String, String> STATIC_CONTENT_TYPES = new HashMap<String, String>();
    private List<Pattern> staticResourcesList;
    private String staticWelcomeFile;
    private List<Pattern> redirectList;
    private String dispatcherServletPath;
    private String dispatcherServletName;
    private Map<String, String> redirectAttributes;
    private boolean redirectQueryCheck;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.staticResourcesList = AbstractHTTPServlet.parseListSequence(servletConfig.getInitParameter(STATIC_RESOURCES_PARAMETER));
        this.staticWelcomeFile = servletConfig.getInitParameter(STATIC_WELCOME_FILE_PARAMETER);
        this.redirectList = AbstractHTTPServlet.parseListSequence(servletConfig.getInitParameter(REDIRECTS_PARAMETER));
        this.redirectQueryCheck = Boolean.valueOf(servletConfig.getInitParameter(REDIRECT_QUERY_CHECK_PARAMETER));
        this.dispatcherServletName = servletConfig.getInitParameter(REDIRECT_SERVLET_NAME_PARAMETER);
        this.dispatcherServletPath = servletConfig.getInitParameter(REDIRECT_SERVLET_PATH_PARAMETER);
        this.redirectAttributes = AbstractHTTPServlet.parseMapSequence(servletConfig.getInitParameter(REDIRECT_ATTRIBUTES_PARAMETER));
    }

    public final void init(final FilterConfig filterConfig) throws ServletException {
        this.init(new ServletConfig(){

            public String getServletName() {
                return filterConfig.getFilterName();
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }
        });
    }

    protected static List<Pattern> parseListSequence(String values) {
        if (values != null) {
            String[] pathValues;
            LinkedList<Pattern> list = new LinkedList<Pattern>();
            for (String value : pathValues = values.split(" ")) {
                String theValue = value.trim();
                if (theValue.length() <= 0) continue;
                list.add(Pattern.compile(theValue));
            }
            return list;
        }
        return null;
    }

    protected static Map<String, String> parseMapSequence(String sequence) {
        if (sequence != null) {
            String[] pairs;
            sequence = sequence.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs = sequence.split(" ")) {
                String thePair = pair.trim();
                if (thePair.length() == 0) continue;
                String[] value = thePair.split("=");
                if (value.length == 2) {
                    map.put(value[0].trim(), value[1].trim());
                    continue;
                }
                map.put(thePair, "");
            }
            return map;
        }
        return Collections.emptyMap();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException("Unrecognized HTTP request or response object");
        }
        String method = request.getMethod();
        if (KNOWN_HTTP_VERBS.contains(method)) {
            super.service(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean staticWelcomeFileMatch;
        if ((this.dispatcherServletPath != null || this.dispatcherServletName != null) && (this.redirectList != null && this.matchPath(this.redirectList, request) || this.redirectList == null)) {
            this.redirect(request, response, request.getPathInfo());
            return;
        }
        boolean staticResourcesMatch = this.staticResourcesList != null && this.matchPath(this.staticResourcesList, request);
        boolean bl = staticWelcomeFileMatch = this.staticWelcomeFile != null && (StringUtils.isEmpty(request.getPathInfo()) || request.getPathInfo().equals("/"));
        if (staticResourcesMatch || staticWelcomeFileMatch) {
            this.serveStaticContent(request, response, staticWelcomeFileMatch ? this.staticWelcomeFile : request.getPathInfo());
            return;
        }
        this.invoke(request, response);
    }

    private boolean matchPath(List<Pattern> values, HttpServletRequest request) {
        String queryString;
        String path = request.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if (this.redirectQueryCheck && (queryString = request.getQueryString()) != null && queryString.length() > 0) {
            path = path + "?" + queryString;
        }
        for (Pattern pattern : values) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    protected void serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        InputStream is = super.getServletContext().getResourceAsStream(pathInfo);
        if (is == null) {
            throw new ServletException("Static resource " + pathInfo + " is not available");
        }
        try {
            String type;
            int ind = pathInfo.lastIndexOf(".");
            if (ind != -1 && ind < pathInfo.length() && (type = STATIC_CONTENT_TYPES.get(pathInfo.substring(ind + 1))) != null) {
                response.setContentType(type);
            }
            ServletOutputStream os = response.getOutputStream();
            IOUtils.copy(is, (OutputStream)os);
            os.flush();
        }
        catch (IOException ex) {
            throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
        }
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        RequestDispatcher rd;
        String theServletPath = this.dispatcherServletPath == null ? "/" : this.dispatcherServletPath;
        ServletContext sc = super.getServletContext();
        RequestDispatcher requestDispatcher = rd = this.dispatcherServletName != null ? sc.getNamedDispatcher(this.dispatcherServletName) : sc.getRequestDispatcher(theServletPath + pathInfo);
        if (rd == null) {
            String errorMessage = "No RequestDispatcher can be created for path " + pathInfo;
            if (this.dispatcherServletName != null) {
                errorMessage = errorMessage + ", dispatcher name: " + this.dispatcherServletName;
            }
            throw new ServletException(errorMessage);
        }
        try {
            for (Map.Entry<String, String> entry : this.redirectAttributes.entrySet()) {
                request.setAttribute(entry.getKey(), (Object)entry.getValue());
            }
            HttpServletRequestFilter servletRequest = new HttpServletRequestFilter(request, pathInfo, theServletPath);
            rd.forward((ServletRequest)servletRequest, (ServletResponse)response);
        }
        catch (Throwable ex) {
            throw new ServletException("RequestDispatcher for path " + pathInfo + " has failed");
        }
    }

    protected abstract void invoke(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    static {
        STATIC_CONTENT_TYPES.put("html", "text/html");
        STATIC_CONTENT_TYPES.put("txt", "text/plain");
        STATIC_CONTENT_TYPES.put("css", "text/css");
        STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
        STATIC_CONTENT_TYPES.put("xsd", "application/xml");
    }

    private static class HttpServletRequestFilter
    extends HttpServletRequestWrapper {
        private String pathInfo;
        private String servletPath;

        public HttpServletRequestFilter(HttpServletRequest request, String pathInfo, String servletPath) {
            super(request);
            this.pathInfo = pathInfo;
            this.servletPath = servletPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            String contextPath = this.getContextPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            return contextPath + this.servletPath + this.pathInfo;
        }

        public String getParameter(String name) {
            if ("http.service.redirection".equals(name)) {
                return "true";
            }
            return super.getParameter(name);
        }
    }
}

