/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;

public class Trust10
extends AbstractSecurityAssertion {
    private boolean mustSupportClientChallenge;
    private boolean mustSupportServerChallenge;
    private boolean requireClientEntropy;
    private boolean requireServerEntropy;
    private boolean mustSupportIssuedTokens;

    public Trust10(SPConstants version) {
        super(version);
    }

    public boolean isMustSupportClientChallenge() {
        return this.mustSupportClientChallenge;
    }

    public void setMustSupportClientChallenge(boolean mustSupportClientChallenge) {
        this.mustSupportClientChallenge = mustSupportClientChallenge;
    }

    public boolean isMustSupportIssuedTokens() {
        return this.mustSupportIssuedTokens;
    }

    public void setMustSupportIssuedTokens(boolean mustSupportIssuedTokens) {
        this.mustSupportIssuedTokens = mustSupportIssuedTokens;
    }

    public boolean isMustSupportServerChallenge() {
        return this.mustSupportServerChallenge;
    }

    public void setMustSupportServerChallenge(boolean mustSupportServerChallenge) {
        this.mustSupportServerChallenge = mustSupportServerChallenge;
    }

    public boolean isRequireClientEntropy() {
        return this.requireClientEntropy;
    }

    public void setRequireClientEntropy(boolean requireClientEntropy) {
        this.requireClientEntropy = requireClientEntropy;
    }

    public boolean isRequireServerEntropy() {
        return this.requireServerEntropy;
    }

    public void setRequireServerEntropy(boolean requireServerEntropy) {
        this.requireServerEntropy = requireServerEntropy;
    }

    public QName getRealName() {
        return SP11Constants.TRUST_10;
    }

    public QName getName() {
        return SP11Constants.TRUST_10;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String wspPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (wspPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isMustSupportClientChallenge()) {
            writer.writeStartElement(prefix, "MustSupportClientChanllenge", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportServerChallenge()) {
            writer.writeStartElement(prefix, "MustSupportServerChanllenge", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireClientEntropy()) {
            writer.writeStartElement(prefix, "RequireClientEntropy", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireServerEntropy()) {
            writer.writeStartElement(prefix, "RequireServerEntropy", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportIssuedTokens()) {
            writer.writeStartElement(prefix, "MustSupportIssuedTokens", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public short getType() {
        return 5;
    }
}

