/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public class AsyncCallbackFuture
implements Runnable,
Future {
    private static final Logger LOG = LogUtils.getL7dLogger(AsyncCallbackFuture.class);
    private final Response response;
    private final AsyncHandler callback;
    private boolean done;

    public AsyncCallbackFuture(Response r, AsyncHandler c) {
        this.response = r;
        this.callback = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            this.callback.handleResponse(this.response);
        }
        finally {
            this.done = true;
            this.notifyAll();
        }
    }

    public boolean cancel(boolean interrupt) {
        return this.response.cancel(interrupt);
    }

    public boolean isCancelled() {
        return this.response.isCancelled();
    }

    public boolean isDone() {
        return this.done;
    }

    public Object get() throws InterruptedException, ExecutionException {
        this.waitForCallbackExecutionToFinish();
        return null;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long ms = TimeUnit.MILLISECONDS.convert(timeout, unit);
        this.waitForCallbackExecutionToFinish(ms);
        return null;
    }

    private synchronized void waitForCallbackExecutionToFinish() {
        while (!this.done) {
            LOG.fine("waiting for callback to finish execution.");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitForCallbackExecutionToFinish(long millis) throws TimeoutException {
        while (!this.done && millis > 0L) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("waiting (max " + millis + " milliseconds for callback to finish execution (max .");
            }
            long startedAt = System.currentTimeMillis();
            try {
                this.wait(millis);
            }
            catch (InterruptedException ex) {
                millis -= System.currentTimeMillis() - startedAt;
            }
        }
        if (!this.done) {
            throw new TimeoutException(new Message("ASYNC_HANDLER_TIMEDOUT_EXC", LOG, new Object[0]).toString());
        }
    }
}

