/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentDeserializer {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHOLD = 102400;
    private static final Pattern CONTENT_TYPE_BOUNDARY_PATTERN = Pattern.compile("boundary=\"?([^\";]*)");
    private static final Pattern INPUT_STREAM_BOUNDARY_PATTERN = Pattern.compile("^--(----=_Part_\\S*)", 8);
    private boolean lazyLoading = true;
    private PushbackInputStream stream;
    private byte[] boundary;
    private String contentType;
    private LazyAttachmentCollection attachments;
    private Message message;
    private InputStream body;
    private Set<DelegatingInputStream> loaded = new HashSet<DelegatingInputStream>();

    public AttachmentDeserializer(Message message) {
        this.message = message;
    }

    public void initializeAttachments() throws IOException {
        this.initializeRootMessage();
        this.attachments = new LazyAttachmentCollection(this);
        this.message.setAttachments(this.attachments);
    }

    protected void initializeRootMessage() throws IOException {
        this.contentType = (String)this.message.get("Content-Type");
        if (this.contentType == null) {
            throw new IllegalStateException("Content-Type can not be empty!");
        }
        if (this.message.getContent(InputStream.class) == null) {
            throw new IllegalStateException("An InputStream must be provided!");
        }
        if (this.contentType.toLowerCase().indexOf("multipart/related") != -1) {
            String boundaryString = this.findBoundaryFromContentType(this.contentType);
            if (null == boundaryString) {
                boundaryString = this.findBoundaryFromInputStream();
            }
            if (null == boundaryString) {
                throw new IOException("Couldn't determine the boundary from the message!");
            }
            this.boundary = boundaryString.getBytes("utf-8");
            this.stream = new PushbackInputStream(this.message.getContent(InputStream.class), this.boundary.length * 2);
            if (!AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary)) {
                throw new IOException("Couldn't find MIME boundary: " + boundaryString);
            }
            try {
                new InternetHeaders((InputStream)this.stream);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            this.body = new DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary));
            this.message.setContent(InputStream.class, this.body);
        }
    }

    private String findBoundaryFromContentType(String ct) throws IOException {
        Matcher m = CONTENT_TYPE_BOUNDARY_PATTERN.matcher(ct);
        return m.find() ? "--" + m.group(1) : null;
    }

    private String findBoundaryFromInputStream() throws IOException {
        InputStream is = this.message.getContent(InputStream.class);
        PushbackInputStream in = new PushbackInputStream(is, 4096);
        byte[] buf = new byte[2048];
        int i = in.read(buf);
        String msg = IOUtils.newStringFromBytes(buf, 0, i);
        in.unread(buf, 0, i);
        this.message.setContent(InputStream.class, in);
        Matcher m = INPUT_STREAM_BOUNDARY_PATTERN.matcher(msg);
        return m.find() ? "--" + m.group(1) : null;
    }

    private void setStreamedAttachmentProperties(CachedOutputStream bos) throws IOException {
        Object threshold;
        Object directory = this.message.getContextualProperty(ATTACHMENT_DIRECTORY);
        if (directory != null) {
            if (directory instanceof File) {
                bos.setOutputDir((File)directory);
            } else {
                bos.setOutputDir(new File((String)directory));
            }
        }
        if ((threshold = this.message.getContextualProperty(ATTACHMENT_MEMORY_THRESHOLD)) != null) {
            if (threshold instanceof Long) {
                bos.setThreshold((Long)threshold);
            } else {
                bos.setThreshold(Long.valueOf((String)threshold));
            }
        } else {
            bos.setThreshold(102400L);
        }
    }

    public AttachmentImpl readNext() throws IOException {
        InternetHeaders headers;
        this.cacheStreamedAttachments();
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        try {
            headers = new InternetHeaders((InputStream)this.stream);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        String id = headers.getHeader("Content-ID", null);
        id = id != null && id.startsWith("<") ? id.substring(1, id.length() - 1) : "Content-ID: <root.message@cxf.apache.org";
        id = URLDecoder.decode(id.startsWith("cid:") ? id.substring(4) : id, "UTF-8");
        AttachmentImpl att = new AttachmentImpl(id);
        this.setupAttachment(att, headers);
        return att;
    }

    private void cacheStreamedAttachments() throws IOException {
        if (this.body instanceof DelegatingInputStream && !((DelegatingInputStream)this.body).isClosed()) {
            this.cache((DelegatingInputStream)this.body, true);
            this.message.setContent(InputStream.class, this.body);
        }
        for (Attachment a : this.attachments.getLoadedAttachments()) {
            DataSource s = a.getDataHandler().getDataSource();
            this.cache((DelegatingInputStream)s.getInputStream(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(DelegatingInputStream input, boolean deleteOnClose) throws IOException {
        if (this.loaded.contains(input)) {
            return;
        }
        this.loaded.add(input);
        CachedOutputStream out = null;
        try {
            out = new CachedOutputStream();
            this.setStreamedAttachmentProperties(out);
            IOUtils.copy(input, out);
            input.setInputStream(out.getInputStream());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static boolean readTillFirstBoundary(PushbackInputStream pbs, byte[] bp) throws IOException {
        int value = pbs.read();
        pbs.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pbs.read();
            if ((byte)value != bp[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < bp.length && (byte)value == bp[boundaryIndex]; ++boundaryIndex) {
                value = pbs.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != bp.length) continue;
            if (value == 13) {
                pbs.read();
            }
            return true;
        }
        return false;
    }

    private void setupAttachment(AttachmentImpl att, InternetHeaders headers) throws IOException {
        MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(this.stream, this.boundary);
        String ct = headers.getHeader("Content-Type", null);
        AttachmentDataSource source = new AttachmentDataSource(ct, new DelegatingInputStream(partStream));
        att.setDataHandler(new DataHandler((DataSource)source));
        Enumeration e = headers.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding") && header.getValue().equalsIgnoreCase("binary")) {
                att.setXOP(true);
            }
            att.setHeader(header.getName(), header.getValue());
        }
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }
}

