/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.runtime.CorbaStreamReader;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaStreamFaultInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaStreamFaultInInterceptor.class);

    public CorbaStreamFaultInInterceptor() {
        super("unmarshal");
        this.addAfter(ClientFaultConverter.class.getName());
    }

    @Override
    public void handleMessage(Message msg) {
        CorbaMessage message = (CorbaMessage)msg;
        try {
            SystemException sysEx = message.getSystemException();
            if (sysEx != null) {
                message.setContent(Exception.class, sysEx);
                return;
            }
            CorbaStreamable exStreamable = message.getStreamableException();
            if (exStreamable != null) {
                DataReader<XMLStreamReader> reader = this.getDataReader(message);
                BindingOperationInfo bopInfo = message.getExchange().get(BindingOperationInfo.class);
                OperationInfo opInfo = bopInfo.getOperationInfo();
                ServiceInfo service = message.getExchange().get(ServiceInfo.class);
                ORB orb = (ORB)message.get("orb");
                if (orb == null) {
                    orb = message.getExchange().get(ORB.class);
                }
                QName elName = new QName("", exStreamable.getName());
                FaultInfo fault = this.getFaultInfo(opInfo, elName);
                CorbaTypeEventProducer faultEventProducer = CorbaHandlerUtils.getTypeEventProducer(exStreamable.getObject(), service, orb);
                CorbaStreamReader streamReader = new CorbaStreamReader(faultEventProducer);
                Object e = reader.read(fault.getMessageParts().get(0), streamReader);
                if (!(e instanceof Exception)) {
                    Class exClass = fault.getProperty(Class.class.getName(), Class.class);
                    if (exClass != null) {
                        Class<?> beanClass = e.getClass();
                        Constructor constructor = exClass.getConstructor(String.class, beanClass);
                        e = constructor.newInstance("", e);
                    } else {
                        Fault faultEx = (Fault)message.getContent(Exception.class);
                        if (e instanceof Document) {
                            this.createFaultDetail((Document)e, fault, faultEx);
                        }
                        e = faultEx;
                    }
                }
                message.setContent(Exception.class, (Exception)e);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "CORBA unmarshalFault exception", ex);
            throw new CorbaBindingException("CORBA unmarshalFault exception", ex);
        }
    }

    private void createFaultDetail(Document faultData, FaultInfo faultInfo, Fault faultEx) {
        MessagePartInfo partInfo = faultInfo.getMessageParts().get(0);
        QName partInfoName = partInfo.getElementQName();
        Document faultDoc = DOMUtils.createDocument();
        Element faultElement = faultDoc.createElement("detail");
        faultDoc.appendChild(faultElement);
        Element partElement = faultDoc.createElementNS(partInfoName.getNamespaceURI(), partInfoName.getLocalPart());
        Element faultDataElement = (Element)faultData.getFirstChild();
        NodeList nodeList = faultDataElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node importedFaultData = faultDoc.importNode(nodeList.item(i), true);
            partElement.appendChild(importedFaultData);
        }
        faultElement.appendChild(partElement);
        faultEx.setDetail(faultElement);
    }

    protected FaultInfo getFaultInfo(OperationInfo opInfo, QName faultName) {
        for (FaultInfo fault : opInfo.getFaults()) {
            MessagePartInfo partInfo = fault.getMessageParts().get(0);
            if (partInfo.isElement() && partInfo.getElementQName().getLocalPart().equals(faultName.getLocalPart())) {
                return fault;
            }
            if (!partInfo.getTypeQName().getLocalPart().equals(faultName.getLocalPart())) continue;
            return fault;
        }
        return null;
    }

    protected DataReader<XMLStreamReader> getDataReader(CorbaMessage message) {
        Service serviceModel = ServiceModelUtil.getService(message.getExchange());
        DataReader<XMLStreamReader> dataReader = serviceModel.getDataBinding().createReader(XMLStreamReader.class);
        if (dataReader == null) {
            throw new CorbaBindingException("Couldn't create data reader for incoming fault message");
        }
        return dataReader;
    }
}

