/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.Path;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.Context;
import org.apache.cxf.jaxrs.JAXRSUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.URITemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResourceInfo {
    private boolean root;
    private Class<?> resourceClass;
    private Class<?> serviceClass;
    private URITemplate uriTemplate;
    private MethodDispatcher methodDispatcher;
    private ResourceProvider resourceProvider;
    private List<ClassResourceInfo> subClassResourceInfo = new ArrayList<ClassResourceInfo>();
    private List<Field> httpContexts;
    private List<Field> resources;

    public ClassResourceInfo(Class<?> theResourceClass) {
        this(theResourceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, boolean theRoot) {
        this(theResourceClass, theResourceClass, theRoot);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass) {
        this(theResourceClass, theServiceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot) {
        this.resourceClass = theResourceClass;
        this.serviceClass = theServiceClass;
        this.root = theRoot;
        this.initHttpContexts();
        this.initResources();
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setMethodDispatcher(MethodDispatcher md) {
        this.methodDispatcher = md;
    }

    public boolean hasSubResources() {
        return !this.subClassResourceInfo.isEmpty();
    }

    public void addSubClassResourceInfo(ClassResourceInfo cri) {
        this.subClassResourceInfo.add(cri);
    }

    public List<ClassResourceInfo> getSubClassResourceInfo() {
        return this.subClassResourceInfo;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.resourceProvider = rp;
    }

    private void initHttpContexts() {
        Field[] fields;
        if (this.resourceClass == null || !this.root) {
            return;
        }
        this.httpContexts = new ArrayList<Field>();
        for (Field f : fields = this.getServiceClass().getDeclaredFields()) {
            Context context = f.getAnnotation(Context.class);
            if (context == null) continue;
            this.httpContexts.add(f);
        }
    }

    private void initResources() {
        Field[] fields;
        if (this.resourceClass == null || !this.root) {
            return;
        }
        this.resources = new ArrayList<Field>();
        for (Field f : fields = this.getServiceClass().getDeclaredFields()) {
            Resource resource = f.getAnnotation(Resource.class);
            if (resource == null) continue;
            this.resources.add(f);
        }
    }

    public ProduceMime getProduceMime() {
        return (ProduceMime)JAXRSUtils.getClassAnnotation(this.getServiceClass(), ProduceMime.class);
    }

    public ConsumeMime getConsumeMime() {
        return (ConsumeMime)JAXRSUtils.getClassAnnotation(this.getServiceClass(), ConsumeMime.class);
    }

    public Path getPath() {
        return (Path)JAXRSUtils.getClassAnnotation(this.getServiceClass(), Path.class);
    }

    public List<Field> getHttpContexts() {
        List<Field> ret = this.httpContexts != null ? Collections.unmodifiableList(this.httpContexts) : Collections.emptyList();
        return ret;
    }

    public List<Field> getResources() {
        List<Field> ret = this.resources != null ? Collections.unmodifiableList(this.resources) : Collections.emptyList();
        return ret;
    }
}

