/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNode {
    private String prefix;
    private QName name;
    private String attributeName;
    private String attributeValue;
    private boolean isDefaultAttributeValue;
    private XNode parentNode;
    private XNode failurePoint;
    private Map<String, String> nsMap = new HashMap<String, String>();

    public void setFailurePoint(XNode point) {
        this.failurePoint = point;
    }

    public XNode getFailurePoint() {
        return this.failurePoint;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    public QName getQName() {
        return this.name;
    }

    public void setQName(QName newName) {
        this.name = newName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String newAttributeName) {
        this.attributeName = newAttributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String newAttributeValue) {
        this.attributeValue = newAttributeValue;
    }

    public void setDefaultAttributeValue(boolean b) {
        this.isDefaultAttributeValue = b;
    }

    public boolean isDefaultAttributeValue() {
        return this.isDefaultAttributeValue;
    }

    public XNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(XNode newParentNode) {
        this.parentNode = newParentNode;
    }

    public Map<String, String> getNSMap() {
        return this.nsMap;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.name.getLocalPart());
        sb.append(":");
        sb.append(this.getAttributeValue());
        sb.append("]");
        return sb.toString();
    }

    public String getPlainText() {
        StringBuffer sb = new StringBuffer();
        Stack<XNode> parentNodes = this.getParentNodes();
        while (!parentNodes.empty()) {
            sb.append(parentNodes.pop().getText());
        }
        sb.append(this.getText());
        this.nsMap.put(this.prefix, this.name.getNamespaceURI());
        return sb.toString();
    }

    public String getXPath() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        sb.append(this.prefix);
        sb.append(":");
        sb.append(this.name.getLocalPart());
        if (!StringUtils.isEmpty(this.attributeName) && !StringUtils.isEmpty(this.attributeValue)) {
            sb.append("[");
            if (this.isDefaultAttributeValue) {
                sb.append("not(@");
                sb.append(this.attributeName);
                sb.append(") or ");
            }
            sb.append("@");
            sb.append(this.attributeName);
            sb.append("='");
            sb.append(this.attributeValue);
            sb.append("'");
            sb.append("]");
        }
        return sb.toString();
    }

    private Stack<XNode> getParentNodes() {
        Stack<XNode> parentNodes = new Stack<XNode>();
        for (XNode pNode = this.getParentNode(); pNode != null; pNode = pNode.getParentNode()) {
            this.nsMap.put(pNode.getPrefix(), pNode.getQName().getNamespaceURI());
            parentNodes.push(pNode);
        }
        return parentNodes;
    }

    public String toString() {
        Stack<XNode> parentNodes = this.getParentNodes();
        StringBuffer sb = new StringBuffer();
        while (!parentNodes.empty()) {
            sb.append(parentNodes.pop().getXPath());
        }
        sb.append(this.getXPath());
        this.nsMap.put(this.prefix, this.name.getNamespaceURI());
        return sb.toString();
    }

    private boolean matches(Element el) {
        if (el.getLocalName().equals(this.name.getLocalPart()) && el.getNamespaceURI().equals(this.name.getNamespaceURI())) {
            if (!StringUtils.isEmpty(this.attributeName) && !StringUtils.isEmpty(this.attributeValue)) {
                String v = el.getAttribute(this.attributeName);
                if (this.attributeValue.equals(v) || StringUtils.isEmpty(v) && this.isDefaultAttributeValue) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean matches(Element el, Stack<XNode> stack) {
        if (this.matches(el)) {
            if (stack.isEmpty()) {
                return true;
            }
            XNode next = stack.pop();
            for (Node nd = el.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                if (!(nd instanceof Element) || !next.matches(el = (Element)nd, stack)) continue;
                return true;
            }
            stack.push(next);
        }
        return false;
    }

    public boolean matches(Document doc) {
        XNode pNode;
        Stack<XNode> nodes = new Stack<XNode>();
        nodes.push(this);
        for (pNode = this.getParentNode(); pNode != null; pNode = pNode.getParentNode()) {
            nodes.push(pNode);
        }
        pNode = (XNode)nodes.pop();
        return pNode.matches(doc.getDocumentElement(), nodes);
    }
}

