/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
ConduitInitiator {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/local";
    public static final String MESSAGE_FILTER_PROPERTIES = LocalTransportFactory.class.getName() + ".filterProperties";
    public static final String MESSAGE_INCLUDE_PROPERTIES = LocalTransportFactory.class.getName() + ".includeProperties";
    private static final Logger LOG = LogUtils.getL7dLogger(LocalTransportFactory.class);
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Map<String, Destination> destinations = new HashMap<String, Destination>();
    private Bus bus;
    private Set<String> messageFilterProperties;
    private Set<String> messageIncludeProperties;

    public LocalTransportFactory() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(TRANSPORT_ID);
        this.setTransportIds(ids);
        this.messageFilterProperties = new HashSet<String>();
        this.messageIncludeProperties = new HashSet<String>();
        this.messageFilterProperties.add("org.apache.cxf.client");
        this.messageIncludeProperties.add(Message.PROTOCOL_HEADERS);
        this.messageIncludeProperties.add(Message.ENCODING);
        this.messageIncludeProperties.add("Content-Type");
        this.messageIncludeProperties.add("Accept");
        this.messageIncludeProperties.add(Message.RESPONSE_CODE);
    }

    @Resource(name="cxf")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public Destination getDestination(EndpointInfo ei) throws IOException {
        return this.getDestination(ei, this.createReference(ei));
    }

    protected Destination getDestination(EndpointInfo ei, EndpointReferenceType reference) throws IOException {
        Destination d = this.destinations.get(reference.getAddress().getValue());
        if (d == null) {
            d = this.createDestination(ei, reference);
            this.destinations.put(reference.getAddress().getValue(), d);
        }
        return d;
    }

    private Destination createDestination(EndpointInfo ei, EndpointReferenceType reference) {
        LOG.info("Creating destination for address " + reference.getAddress().getValue());
        return new LocalDestination(this, reference, ei);
    }

    void remove(LocalDestination destination) {
        this.destinations.remove(destination);
    }

    @Override
    public Conduit getConduit(EndpointInfo ei) throws IOException {
        return new LocalConduit(this, (LocalDestination)this.getDestination(ei));
    }

    @Override
    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target) throws IOException {
        return new LocalConduit(this, (LocalDestination)this.getDestination(ei, target));
    }

    EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        epr.setAddress(address);
        return epr;
    }

    @Override
    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    public Set<String> getMessageFilterProperties() {
        return this.messageFilterProperties;
    }

    public void setMessageFilterProperties(Set<String> props) {
        this.messageFilterProperties = props;
    }

    public Set<String> getIncludeMessageProperties() {
        return this.messageIncludeProperties;
    }

    public void setMessageIncludeProperties(Set<String> props) {
        this.messageIncludeProperties = props;
    }

    public void copy(Message message, Message copy) {
        Set<Object> includes;
        Set<Object> filter = CastUtils.cast((Set)message.get(MESSAGE_FILTER_PROPERTIES));
        if (filter == null) {
            filter = this.messageFilterProperties;
        }
        if ((includes = CastUtils.cast((Set)message.get(MESSAGE_INCLUDE_PROPERTIES))) == null) {
            includes = this.messageIncludeProperties;
        }
        for (Map.Entry e : message.entrySet()) {
            if (!includes.contains(e.getKey()) && !this.messageIncludeProperties.contains(e.getKey()) || filter.contains(e.getKey())) continue;
            copy.put(e.getKey(), e.getValue());
        }
    }

    static {
        URI_PREFIXES.add("local://");
    }
}

