/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.StringTokenizer;

public final class URLFactory {
    public static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String UNKNOWN_PROPTOCL_EX_MSG = "unknown protocol: ";

    private URLFactory() {
    }

    public static URL createURL(String spec) throws MalformedURLException {
        return URLFactory.createURL(null, spec);
    }

    public static URL createURL(URL context, String spec) throws MalformedURLException {
        URL url;
        block3: {
            url = null;
            try {
                url = new URL(context, spec);
            }
            catch (MalformedURLException mue) {
                URLStreamHandler handler;
                String msg = mue.getMessage();
                if (msg.indexOf(UNKNOWN_PROPTOCL_EX_MSG) != -1 && (handler = URLFactory.findHandler(msg.substring(UNKNOWN_PROPTOCL_EX_MSG.length()))) != null) {
                    url = new URL(context, spec, handler);
                }
                if (url != null) break block3;
                throw mue;
            }
        }
        return url;
    }

    public static URLStreamHandler findHandler(String protocol) {
        URLStreamHandler handler = null;
        String packagePrefixList = System.getProperty(PROTOCOL_HANDLER_PKGS, "");
        StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
        while (handler == null && packagePrefixIter.hasMoreTokens()) {
            String packagePrefix = packagePrefixIter.nextToken().trim();
            try {
                Class<?> cls;
                block5: {
                    String clsName = packagePrefix + "." + protocol + ".Handler";
                    cls = null;
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (cl == null) break block5;
                        cls = cl.loadClass(clsName);
                    }
                }
                if (cls == null) continue;
                handler = (URLStreamHandler)cls.newInstance();
            }
            catch (Exception ignored) {
                ignored.getMessage();
            }
        }
        return handler;
    }
}

