/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.corba.common.ProcessorEnvironment;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToCorbaProcessor;

public class WSDLToIDL
extends AbstractCXFToolContainer {
    static final String TOOL_NAME = "wsdltoidl";
    private static String[] args;
    String idlOutput;
    String wsdlOutput;

    public WSDLToIDL(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set getArrayKeys() {
        return new HashSet();
    }

    public void execute(boolean exitOnFinish) {
        WSDLToCorbaProcessor corbaProcessor = new WSDLToCorbaProcessor();
        ProcessorEnvironment env = null;
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                env = new ProcessorEnvironment();
                env.setParameters(this.getParametersMap(this.getArrayKeys()));
                if (this.isVerboseOn()) {
                    env.put("verbose", Boolean.TRUE);
                }
                env.put("args", args);
                CommandDocument doc = super.getCommandDocument();
                if (doc.hasParameter("corba")) {
                    env.put("corba", Boolean.TRUE);
                }
                if (doc.hasParameter("idl")) {
                    env.put("idl", Boolean.TRUE);
                }
                this.initialise(env);
                this.validate(env);
                corbaProcessor.setEnvironment(env);
                corbaProcessor.process();
            }
        }
        catch (ToolException ex) {
            System.err.println("Error : " + ex.getMessage());
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            System.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace();
            }
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace();
            }
            throw new ToolException(ex.getMessage(), ex.getCause());
        }
    }

    private void initialise(ProcessorEnvironment env) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (env.optionSet("binding")) {
            env.put("binding", doc.getParameter("binding"));
        }
        if (env.optionSet("porttype")) {
            env.put("porttype", doc.getParameter("porttype"));
        }
        if (env.optionSet("wsdlurl")) {
            String wsdlname = doc.getParameter("wsdlurl");
            env.put("wsdlurl", wsdlname);
        }
        if (env.optionSet("namespace")) {
            env.put("namespace", doc.getParameter("namespace"));
        }
        if (env.optionSet("wsdloutputfile")) {
            env.put("wsdloutputfile", doc.getParameter("wsdloutputfile"));
        }
        if (env.optionSet("idloutputfile")) {
            env.put("idloutputfile", doc.getParameter("idloutputfile"));
        }
        if (env.optionSet("outputdir")) {
            env.put("outputdir", doc.getParameter("outputdir"));
        }
    }

    public static void run(String[] arguments) throws Exception {
        ToolRunner.runTool(WSDLToIDL.class, WSDLToIDL.class.getResourceAsStream("/org/apache/cxf/tools/corba/common/toolspec/toolspecs/wsdl2idl.xml"), false, arguments);
    }

    public static void main(String[] arguments) {
        try {
            WSDLToIDL.run(arguments);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            System.exit(1);
        }
    }

    private void validate(ProcessorEnvironment env) throws ToolException {
        File dir;
        String outdir = (String)env.get("outputdir");
        if (outdir != null && !(dir = new File(outdir)).exists()) {
            dir.mkdir();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add(new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

