/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCallback
implements Future<Object[]> {
    protected Map<String, Object> context;
    protected Object[] result;
    protected Throwable exception;
    protected boolean done;
    protected boolean cancelled;
    protected boolean started;

    public void start(Message msg) {
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        this.context = ctx;
        this.result = res;
        this.done = true;
        ClientCallback clientCallback = this;
        synchronized (clientCallback) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        this.context = ctx;
        this.exception = ex;
        this.done = true;
        ClientCallback clientCallback = this;
        synchronized (clientCallback) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.started) {
            this.cancelled = true;
            ClientCallback clientCallback = this;
            synchronized (clientCallback) {
                this.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getResponseContext() throws InterruptedException, ExecutionException {
        ClientCallback clientCallback = this;
        synchronized (clientCallback) {
            if (!this.done) {
                this.wait();
            }
        }
        if (this.cancelled) {
            throw new InterruptedException("Operation Cancelled");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] get() throws InterruptedException, ExecutionException {
        ClientCallback clientCallback = this;
        synchronized (clientCallback) {
            if (!this.done) {
                this.wait();
            }
        }
        if (this.cancelled) {
            throw new InterruptedException("Operation Cancelled");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ClientCallback clientCallback = this;
        synchronized (clientCallback) {
            if (!this.done) {
                unit.timedWait(this, timeout);
            }
        }
        if (this.cancelled) {
            throw new InterruptedException("Operation Cancelled");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

