/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.validator;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.validator.ServiceValidator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.WrapperElement;

public class WrapperStyleNameCollisionValidator
extends ServiceValidator {
    public static final Logger LOG = LogUtils.getL7dLogger(WrapperStyleNameCollisionValidator.class);

    public WrapperStyleNameCollisionValidator() {
    }

    public WrapperStyleNameCollisionValidator(ServiceInfo s) {
        this.service = s;
    }

    public boolean isValid() {
        return this.checkNameColllision();
    }

    private boolean checkNameColllision() {
        InterfaceInfo interfaceInfo = this.service.getInterface();
        if (interfaceInfo != null) {
            for (OperationInfo operation : interfaceInfo.getOperations()) {
                if (this.isValidOperation(operation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidOperation(OperationInfo operation) {
        JAXWSBinding binding;
        ToolContext context = this.service.getProperty(ToolContext.class.getName(), ToolContext.class);
        boolean c = context.optionSet("autoNameResolution");
        boolean valid = false;
        if (operation.getUnwrappedOperation() == null) {
            valid = true;
        }
        if ((binding = operation.getExtensor(JAXWSBinding.class)) != null && !binding.isEnableWrapperStyle()) {
            valid = true;
        }
        if ((binding = operation.getInterface().getExtensor(JAXWSBinding.class)) != null && !binding.isEnableWrapperStyle()) {
            valid = true;
        }
        if ((binding = operation.getInterface().getService().getDescription().getExtensor(JAXWSBinding.class)) != null && !binding.isEnableWrapperStyle()) {
            valid = true;
        }
        if (valid) {
            return true;
        }
        MessagePartInfo input = null;
        MessagePartInfo output = null;
        if (operation.getInput() != null && operation.getInput().getMessageParts().size() == 1) {
            input = operation.getInput().getMessageParts().iterator().next();
        }
        if (operation.getOutput() != null && operation.getOutput().getMessageParts().size() == 1) {
            output = operation.getOutput().getMessageParts().iterator().next();
        }
        if (!c) {
            List<WrapperElement> els;
            HashMap<QName, QName> names = new HashMap<QName, QName>();
            if (input != null) {
                for (WrapperElement element : ProcessorUtil.getWrappedElement(context, input.getElementQName())) {
                    if (names.containsKey(element.getElementName()) && (names.get(element.getElementName()) == element.getSchemaTypeName() || ((QName)names.get(element.getElementName())).equals(element.getSchemaTypeName()))) {
                        this.handleErrors((QName)names.get(element.getElementName()), element);
                        return false;
                    }
                    names.put(element.getElementName(), element.getSchemaTypeName());
                }
            }
            if (output != null && (els = ProcessorUtil.getWrappedElement(context, output.getElementQName())).size() > 1) {
                for (WrapperElement element : els) {
                    if (names.containsKey(element.getElementName()) && names.get(element.getElementName()) != element.getSchemaTypeName() && !((QName)names.get(element.getElementName())).equals(element.getSchemaTypeName())) {
                        this.handleErrors((QName)names.get(element.getElementName()), element);
                        return false;
                    }
                    names.put(element.getElementName(), element.getSchemaTypeName());
                }
            }
        }
        return true;
    }

    private void handleErrors(QName e1, WrapperElement e2) {
        Message msg = new Message("WRAPPER_STYLE_NAME_COLLISION", LOG, e2.getElementName(), e1, e2.getSchemaTypeName());
        this.addErrorMessage(msg.toString());
    }
}

