/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.binding.corba.types;

import javax.xml.namespace.QName;

public abstract class AbstractCorbaTypeListener implements CorbaTypeListener {

    protected QName currentElement;
    protected final CorbaObjectHandler handler;

    public AbstractCorbaTypeListener(CorbaObjectHandler h) {
        handler = h;
    }


    public void processStartElement(QName name) {
        currentElement = name;
    }

    public void processEndElement(QName name) {
        currentElement = null;
    }

    public abstract void processCharacters(String text);

    public CorbaObjectHandler getCorbaObject() {
        return handler;
    }

    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String value) {
    }

    public void processWriteNamespace(String prefix, String namespaceURI) {
    }
}
