/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.ws.commons.schema.XmlSchema;

public final class TypeUtil {
    public static final Log LOG = LogFactory.getLog(TypeUtil.class);

    private TypeUtil() {
    }

    public static Type getReadType(XMLStreamReader xsr, AegisContext context, Type baseType) {
        if (!context.isReadXsiTypes()) {
            if (baseType == null) {
                LOG.warn((Object)("xsi:type reading disabled, and no type available for " + xsr.getName()));
            }
            return baseType;
        }
        String overrideType = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (overrideType != null) {
            QName overrideName = NamespaceHelper.createQName(xsr.getNamespaceContext(), overrideType);
            if (baseType == null || !overrideName.equals(baseType.getSchemaType())) {
                Type improvedType = null;
                if (baseType != null) {
                    TypeMapping tm = baseType.getTypeMapping();
                    improvedType = tm.getType(overrideName);
                }
                if (improvedType == null) {
                    improvedType = context.getRootType(overrideName);
                }
                if (improvedType != null) {
                    return improvedType;
                }
            }
            if (baseType != null) {
                LOG.info((Object)("xsi:type=\"" + overrideName + "\" was specified, but no corresponding Type was registered; defaulting to " + baseType.getSchemaType()));
                return baseType;
            }
            LOG.warn((Object)("xsi:type=\"" + overrideName + "\" was specified, but no corresponding Type was registered; no default."));
            return null;
        }
        if (baseType == null) {
            LOG.warn((Object)("xsi:type absent, and no type available for " + xsr.getName()));
        }
        return baseType;
    }

    public static Type getReadTypeStandalone(XMLStreamReader xsr, AegisContext context, Type baseType) {
        if (baseType != null) {
            return TypeUtil.getReadType(xsr, context, baseType);
        }
        if (!context.isReadXsiTypes()) {
            LOG.warn((Object)("xsi:type reading disabled, and no type available for " + xsr.getName()));
            return null;
        }
        String typeNameString = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeNameString != null) {
            QName schemaTypeName = NamespaceHelper.createQName(xsr.getNamespaceContext(), typeNameString);
            TypeMapping tm = context.getTypeMapping();
            Type type = tm.getType(schemaTypeName);
            if (type == null) {
                type = context.getRootType(schemaTypeName);
            }
            if (type != null) {
                return type;
            }
            LOG.warn((Object)("xsi:type=\"" + schemaTypeName + "\" was specified, but no corresponding Type was registered; no default."));
            return null;
        }
        LOG.warn((Object)("xsi:type was not specified for top-level element " + xsr.getName()));
        return null;
    }

    public static Type getWriteType(AegisContext globalContext, Object value, Type type) {
        Type overrideType;
        if (value != null && type != null && type.getTypeClass() != value.getClass() && (overrideType = globalContext.getRootType(value.getClass())) != null) {
            return overrideType;
        }
        return type;
    }

    public static Type getWriteTypeStandalone(AegisContext globalContext, Object value, Type type) {
        if (type != null) {
            return TypeUtil.getWriteType(globalContext, value, type);
        }
        TypeMapping tm = globalContext.getTypeMapping();
        type = tm.getType(value.getClass());
        return type;
    }

    public static void setAttributeAttributes(QName name, Type type, XmlSchema root) {
        String ns = type.getSchemaType().getNamespaceURI();
        XmlSchemaUtils.addImportIfNeeded(root, ns);
    }
}

