/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;

public class OneWayDecoupledFaultHandler
extends AbstractSoapInterceptor {
    public OneWayDecoupledFaultHandler() {
        super("pre-protocol");
        this.addBefore(MAPCodec.class.getName());
    }

    public void handleMessage(SoapMessage message) {
    }

    public void handleFault(SoapMessage message) {
        Exchange exchange;
        Message inMessage;
        AddressingPropertiesImpl maps;
        if (message.getExchange().isOneWay() && !ContextUtils.isRequestor(message) && (maps = ContextUtils.retrieveMAPs(inMessage = (exchange = message.getExchange()).getInMessage(), false, false, true)) != null && !ContextUtils.isGenericAddress(maps.getFaultTo())) {
            exchange.setOneWay(false);
            exchange.setOutMessage(message);
            Destination destination = this.createDecoupledDestination(exchange, maps.getFaultTo());
            exchange.setDestination(destination);
        }
    }

    protected Destination createDecoupledDestination(Exchange exchange, EndpointReferenceType epr) {
        return ContextUtils.createDecoupledDestination(exchange, epr);
    }
}

