/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DataCodingUtils {
    private DataCodingUtils() {
    }

    public static void readInts4(InputStream inputStream, int[] array, int count) throws IOException {
        int value = 0;
        int octet = 0;
        int readInts = 0;
        int shVal = 0;
        int neeble = 0;
        int neebleNum = 0;
        while (readInts < count) {
            if (neebleNum % 2 == 0) {
                octet = inputStream.read();
                if (octet == -1) {
                    throw new EOFException();
                }
                neeble = octet >> 4;
            } else {
                neeble = octet & 0xF;
            }
            value |= (neeble & 7) << shVal;
            if ((neeble & 8) == 0) {
                array[readInts++] = value;
                shVal = 0;
                value = 0;
            } else {
                shVal += 3;
            }
            ++neebleNum;
        }
    }

    public static int readInt8(InputStream inputStream) throws IOException {
        int value = 0;
        int shVal = 0;
        int octet = 128;
        while ((octet & 0x80) != 0) {
            octet = inputStream.read();
            if (octet == -1) {
                throw new EOFException();
            }
            value |= (octet & 0x7F) << shVal;
            shVal += 7;
        }
        return value;
    }

    public static void writeInt8(OutputStream outputStream, int intValue) throws IOException {
        int value = intValue;
        do {
            int octet = value & 0x7F;
            if ((value >>>= 7) != 0) {
                octet |= 0x80;
            }
            outputStream.write(octet);
        } while (value != 0);
    }

    public static void writeInts4(OutputStream outputStream, int ... values) throws IOException {
        DataCodingUtils.writeInts4(outputStream, values, 0, values.length);
    }

    public static void writeInts4(OutputStream outputStream, int[] array, int offset, int count) throws IOException {
        int shiftValue = 0;
        for (int i = 0; i < count - 1; ++i) {
            int value = array[offset + i];
            shiftValue = DataCodingUtils.writeInt4(outputStream, value, shiftValue, false);
        }
        if (count > 0) {
            DataCodingUtils.writeInt4(outputStream, array[offset + count - 1], shiftValue, true);
        }
    }

    private static int writeInt4(OutputStream outputStream, int intValue, int highValue, boolean flush) throws IOException {
        int nibbleL;
        int value = intValue;
        int hValue = highValue;
        if (hValue > 0) {
            hValue &= 0x70;
            nibbleL = value & 7;
            if ((value >>>= 3) != 0) {
                nibbleL |= 8;
            }
            outputStream.write(hValue | nibbleL);
            if (value == 0) {
                return 0;
            }
        }
        do {
            int nibbleH = (value & 7) << 4;
            if ((value >>>= 3) != 0) {
                nibbleH |= 0x80;
                nibbleL = value & 7;
                if ((value >>>= 3) != 0) {
                    nibbleL |= 8;
                }
            } else {
                if (!flush) {
                    return nibbleH | 0x80;
                }
                nibbleL = 0;
            }
            outputStream.write(nibbleH | nibbleL);
        } while (value != 0);
        return 0;
    }
}

