/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.workqueue.WorkQueueManagerImplMBeanWrapper;

@NoJSR250Annotations(unlessNull={"bus"})
public class WorkQueueManagerImpl
implements WorkQueueManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WorkQueueManagerImpl.class);
    Map<String, AutomaticWorkQueue> namedQueues = new ConcurrentHashMap<String, AutomaticWorkQueue>();
    boolean inShutdown;
    Bus bus;

    public WorkQueueManagerImpl() {
    }

    public WorkQueueManagerImpl(Bus b) {
        this.setBus(b);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public final void setBus(Bus bus) {
        this.bus = bus;
        if (null != bus) {
            bus.setExtension(this, WorkQueueManager.class);
            InstrumentationManager manager = bus.getExtension(InstrumentationManager.class);
            if (null != manager) {
                try {
                    manager.register(new WorkQueueManagerImplMBeanWrapper(this));
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                }
            }
        }
    }

    public synchronized AutomaticWorkQueue getAutomaticWorkQueue() {
        AutomaticWorkQueue defaultQueue = this.getNamedWorkQueue("default");
        if (defaultQueue == null) {
            defaultQueue = this.createAutomaticWorkQueue();
        }
        return defaultQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean processRemainingTasks) {
        this.inShutdown = true;
        for (AutomaticWorkQueue q : this.namedQueues.values()) {
            q.shutdown(processRemainingTasks);
        }
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            while (!this.inShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            for (AutomaticWorkQueue q : this.namedQueues.values()) {
                while (!q.isShutdown()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        for (Handler h : LOG.getHandlers()) {
            h.flush();
        }
    }

    public AutomaticWorkQueue getNamedWorkQueue(String name) {
        return this.namedQueues.get(name);
    }

    public void addNamedWorkQueue(String name, AutomaticWorkQueue q) {
        this.namedQueues.put(name, q);
    }

    private AutomaticWorkQueue createAutomaticWorkQueue() {
        AutomaticWorkQueueImpl impl = new AutomaticWorkQueueImpl("default");
        impl.setManager(this);
        impl.register();
        return impl;
    }
}

