/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Element;

public class SecurityToken {
    private String id;
    private State state = State.UNKNOWN;
    private Element token;
    private Element previousToken;
    private Element attachedReference;
    private Element unattachedReference;
    private Properties properties;
    private boolean changed;
    private byte[] secret;
    private Date created;
    private Date expires;
    private String issuerAddress;
    private String encrKeySha1Value;
    private int associatedHash;
    private String tokenType;
    private X509Certificate x509cert;
    private Crypto crypto;

    public SecurityToken() {
    }

    public SecurityToken(String id) {
        this.id = id;
        this.createDefaultExpires();
    }

    public SecurityToken(String id, Date created, Date expires) {
        this.id = id;
        this.created = created;
        this.expires = expires;
        if (expires == null) {
            this.createDefaultExpires();
        }
    }

    public SecurityToken(String id, Element tokenElem, Date created, Date expires) {
        this.id = id;
        this.token = SecurityToken.cloneElement(tokenElem);
        this.created = created;
        this.expires = expires;
        if (expires == null) {
            this.createDefaultExpires();
        }
    }

    public SecurityToken(String id, Element tokenElem, Element lifetimeElem) {
        this.id = id;
        this.token = SecurityToken.cloneElement(tokenElem);
        if (lifetimeElem != null) {
            this.processLifeTime(lifetimeElem);
        }
        if (this.expires == null) {
            this.createDefaultExpires();
        }
    }

    private static Element cloneElement(Element el) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.setNsRepairing(true);
            StaxUtils.copy(el, (XMLStreamWriter)writer);
            return writer.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            return el;
        }
    }

    private void processLifeTime(Element lifetimeElem) {
        try {
            Element createdElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            this.created = zulu.parse(DOMUtils.getContent(createdElem));
            Element expiresElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            this.expires = zulu.parse(DOMUtils.getContent(expiresElem));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean chnaged) {
        this.changed = chnaged;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Element getToken() {
        return this.token;
    }

    public void setToken(Element token) {
        this.token = token;
    }

    public String getId() {
        return this.id;
    }

    public Element getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(Element previousToken) {
        this.previousToken = SecurityToken.cloneElement(previousToken);
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public void setSecret(byte[] secret) {
        this.secret = secret;
    }

    public Element getAttachedReference() {
        return this.attachedReference;
    }

    public void setAttachedReference(Element attachedReference) {
        if (attachedReference != null) {
            this.attachedReference = SecurityToken.cloneElement(attachedReference);
        }
    }

    public Element getUnattachedReference() {
        return this.unattachedReference;
    }

    public void setUnattachedReference(Element unattachedReference) {
        if (unattachedReference != null) {
            this.unattachedReference = SecurityToken.cloneElement(unattachedReference);
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public String getIssuerAddress() {
        return this.issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }

    public void setSHA1(String sha) {
        this.encrKeySha1Value = sha;
    }

    public String getSHA1() {
        return this.encrKeySha1Value;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String s) {
        this.tokenType = s;
    }

    public String getWsuId() {
        String t;
        Element elem = this.getAttachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        elem = this.getUnattachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        return null;
    }

    public static String getIdFromSTR(Element str) {
        Element child = DOMUtils.getFirstElement(str);
        if (child == null) {
            return null;
        }
        if ("KeyInfo".equals(child.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
            return DOMUtils.getContent(child);
        }
        if (Reference.TOKEN.getLocalPart().equals(child.getLocalName()) && Reference.TOKEN.getNamespaceURI().equals(child.getNamespaceURI())) {
            return child.getAttribute("URI").substring(1);
        }
        return null;
    }

    public void setX509Certificate(X509Certificate cert, Crypto cpt) {
        this.x509cert = cert;
        this.crypto = cpt;
    }

    public X509Certificate getX509Certificate() {
        return this.x509cert;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public void setAssociatedHash(int hash) {
        this.associatedHash = hash;
    }

    public int getAssociatedHash() {
        return this.associatedHash;
    }

    private void createDefaultExpires() {
        this.expires = new Date();
        long currentTime = this.expires.getTime();
        this.expires.setTime(currentTime + 300000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        ISSUED,
        EXPIRED,
        CANCELLED,
        RENEWED;

    }
}

